/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal;

import com.hazelcast.cp.internal.CPGroupInfo;
import com.hazelcast.cp.internal.CPMemberInfo;
import com.hazelcast.cp.internal.MembershipChangeSchedule;
import com.hazelcast.cp.internal.MetadataRaftGroupManager;
import com.hazelcast.cp.internal.RaftServiceDataSerializerHook;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class MetadataRaftGroupSnapshot
implements IdentifiedDataSerializable {
    private final Collection<CPMemberInfo> members = new ArrayList<CPMemberInfo>();
    private long membersCommitIndex;
    private final Collection<CPGroupInfo> groups = new ArrayList<CPGroupInfo>();
    private MembershipChangeSchedule membershipChangeSchedule;
    private List<CPMemberInfo> initialCPMembers;
    private final Set<CPMemberInfo> initializedCPMembers = new HashSet<CPMemberInfo>();
    private MetadataRaftGroupManager.MetadataRaftGroupInitStatus initializationStatus;
    private final Set<Long> initializationCommitIndices = new HashSet<Long>();

    public MetadataRaftGroupSnapshot() {
    }

    public MetadataRaftGroupSnapshot(Collection<CPMemberInfo> members, long membersCommitIndex, Collection<CPGroupInfo> groups, MembershipChangeSchedule membershipChangeSchedule, List<CPMemberInfo> initialCPMembers, Set<CPMemberInfo> initializedCPMembers, MetadataRaftGroupManager.MetadataRaftGroupInitStatus initializationStatus, Set<Long> initializationCommitIndices) {
        this.members.addAll(members);
        this.membersCommitIndex = membersCommitIndex;
        groups.stream().map(CPGroupInfo::new).forEach(this.groups::add);
        this.membershipChangeSchedule = membershipChangeSchedule;
        this.initialCPMembers = initialCPMembers;
        this.initializedCPMembers.addAll(initializedCPMembers);
        this.initializationStatus = initializationStatus;
        this.initializationCommitIndices.addAll(initializationCommitIndices);
    }

    public Collection<CPMemberInfo> getMembers() {
        return Collections.unmodifiableCollection(this.members);
    }

    public long getMembersCommitIndex() {
        return this.membersCommitIndex;
    }

    public Collection<CPGroupInfo> getGroups() {
        return this.groups.stream().map(CPGroupInfo::new).collect(Collectors.toList());
    }

    public MembershipChangeSchedule getMembershipChangeSchedule() {
        return this.membershipChangeSchedule;
    }

    public Set<CPMemberInfo> getInitializedCPMembers() {
        return Collections.unmodifiableSet(this.initializedCPMembers);
    }

    public List<CPMemberInfo> getInitialCPMembers() {
        return Collections.unmodifiableList(this.initialCPMembers);
    }

    public MetadataRaftGroupManager.MetadataRaftGroupInitStatus getInitializationStatus() {
        return this.initializationStatus;
    }

    public Set<Long> getInitializationCommitIndices() {
        return Collections.unmodifiableSet(this.initializationCommitIndices);
    }

    @Override
    public int getFactoryId() {
        return RaftServiceDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 10;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        SerializationUtil.writeCollection(this.members, out);
        out.writeLong(this.membersCommitIndex);
        SerializationUtil.writeCollection(this.groups, out);
        out.writeObject(this.membershipChangeSchedule);
        boolean discoveredInitialCPMembers = this.initialCPMembers != null;
        out.writeBoolean(discoveredInitialCPMembers);
        if (discoveredInitialCPMembers) {
            SerializationUtil.writeList(this.initialCPMembers, out);
        }
        SerializationUtil.writeCollection(this.initializedCPMembers, out);
        out.writeString(this.initializationStatus.name());
        out.writeInt(this.initializationCommitIndices.size());
        for (long commitIndex : this.initializationCommitIndices) {
            out.writeLong(commitIndex);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int i;
        int i2;
        int len = in.readInt();
        for (i2 = 0; i2 < len; ++i2) {
            CPMemberInfo member = (CPMemberInfo)in.readObject();
            this.members.add(member);
        }
        this.membersCommitIndex = in.readLong();
        len = in.readInt();
        for (i2 = 0; i2 < len; ++i2) {
            CPGroupInfo group = (CPGroupInfo)in.readObject();
            this.groups.add(group);
        }
        this.membershipChangeSchedule = (MembershipChangeSchedule)in.readObject();
        boolean discoveredInitialCPMembers = in.readBoolean();
        if (discoveredInitialCPMembers) {
            this.initialCPMembers = SerializationUtil.readList(in);
        }
        len = in.readInt();
        for (i = 0; i < len; ++i) {
            CPMemberInfo member = (CPMemberInfo)in.readObject();
            this.initializedCPMembers.add(member);
        }
        this.initializationStatus = MetadataRaftGroupManager.MetadataRaftGroupInitStatus.valueOf(in.readString());
        len = in.readInt();
        for (i = 0; i < len; ++i) {
            long commitIndex = in.readLong();
            this.initializationCommitIndices.add(commitIndex);
        }
    }

    public String toString() {
        return "MetadataRaftGroupSnapshot{members=" + String.valueOf(this.members) + ", membersCommitIndex=" + this.membersCommitIndex + ", groups=" + String.valueOf(this.groups) + ", membershipChangeSchedule=" + String.valueOf(this.membershipChangeSchedule) + ", initialCPMembers=" + String.valueOf(this.initialCPMembers) + ", initializedCPMembers=" + String.valueOf(this.initializedCPMembers) + ", initializationStatus=" + String.valueOf((Object)this.initializationStatus) + ", initializationCommitIndices=" + String.valueOf(this.initializationCommitIndices) + "}";
    }
}

