/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal;

import com.hazelcast.cluster.Member;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.CPGroupsSnapshot;
import com.hazelcast.cp.CPMember;
import com.hazelcast.cp.internal.CPMemberInfo;
import com.hazelcast.cp.internal.RaftService;
import com.hazelcast.cp.internal.raft.impl.RaftEndpoint;
import com.hazelcast.cp.internal.raft.impl.RaftNode;
import com.hazelcast.cp.internal.raft.impl.RaftNodeImpl;
import com.hazelcast.cp.internal.raftop.metadata.PublishCPGroupInfoOp;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

public class CPGroupViewTracker {
    static final HazelcastProperty LEADER_BROADCAST_TASK_PERIOD_SECONDS = new HazelcastProperty("hazelcast.raft.leadership.broadcast.period.seconds", 30);
    private final NodeEngine nodeEngine;
    private final RaftService raftService;
    private final ILogger logger;
    private final Map<CPGroupId, GroupState> groupIdToState = new ConcurrentHashMap<CPGroupId, GroupState>();
    private final AtomicLong totalPublications = new AtomicLong();

    CPGroupViewTracker(NodeEngine nodeEngine, RaftService raftService) {
        this.nodeEngine = nodeEngine;
        this.raftService = raftService;
        this.logger = nodeEngine.getLogger(this.getClass());
        int leaderBroadcastTaskIntervalSeconds = nodeEngine.getProperties().getInteger(LEADER_BROADCAST_TASK_PERIOD_SECONDS);
        this.logger.fine("Scheduling leader broadcast task with interval %d (s)", leaderBroadcastTaskIntervalSeconds);
        nodeEngine.getExecutionService().scheduleWithRepetition("hz:cpSubsystem", new LeaderBroadcastTask(), leaderBroadcastTaskIntervalSeconds, leaderBroadcastTaskIntervalSeconds, TimeUnit.SECONDS);
    }

    public void setLastKnownLeader(CPGroupId groupId, @Nullable CPMember cpLeader) {
        if (cpLeader == null) {
            this.groupIdToState.remove(groupId);
            return;
        }
        this.groupIdToState.compute(groupId, (id, existingState) -> {
            if (existingState == null || existingState.leader == null || !existingState.leader.equals(cpLeader)) {
                return new GroupState(cpLeader, Collections.emptySet(), -1);
            }
            return existingState;
        });
    }

    public CPMember getLastKnownLeader(CPGroupId groupId) {
        GroupState state = this.groupIdToState.get(groupId);
        return state == null ? null : state.leader;
    }

    @Nullable
    public CPGroupsSnapshot.GroupInfo getGroupInfo(CPGroupId groupId) {
        GroupState state = this.groupIdToState.get(groupId);
        return state == null ? null : state.toGroupInfo();
    }

    public void onCPMemberRemoved(CPMember member) {
        this.groupIdToState.entrySet().removeIf(entry -> {
            if (member.equals(((GroupState)entry.getValue()).leader)) {
                return true;
            }
            ((GroupState)entry.getValue()).followers.remove(member);
            return false;
        });
    }

    public void onCPGroupDestroyed(CPGroupId groupId) {
        GroupState state = this.groupIdToState.remove(groupId);
        if (state != null && state.leader != null && state.leader.equals(this.raftService.getLocalCPMember())) {
            this.publishGroupLeadershipStates();
        }
    }

    public void publishGroupLeadershipStates() {
        RaftEndpoint localCPEndpoint = this.raftService.getLocalCPEndpoint();
        if (localCPEndpoint == null) {
            this.logger.fine("Unable to publish local CP group view state as the local CP endpoint is null");
            return;
        }
        Collection<CPGroupId> leadedGroups = this.raftService.getLeadedGroups();
        HashMap<CPGroupId, Set<CPMember>> followersMap = new HashMap<CPGroupId, Set<CPMember>>(leadedGroups.size());
        HashMap<CPGroupId, Integer> groupToTerm = new HashMap<CPGroupId, Integer>(leadedGroups.size());
        for (CPGroupId groupId : leadedGroups) {
            RaftNode raftNode = this.raftService.getRaftNode(groupId);
            if (raftNode == null) {
                this.logger.fine("Unable to retrieve local RaftNode information for led group: %s", groupId);
                continue;
            }
            if (this.raftService.isRaftGroupDestroyedOrTerminated(groupId)) continue;
            Collection<RaftEndpoint> appliedMembers = raftNode.getAppliedMembers();
            HashSet<CPMember> followers = new HashSet<CPMember>(appliedMembers.size() - 1);
            groupToTerm.put(groupId, ((RaftNodeImpl)raftNode).state().term());
            for (RaftEndpoint endpoint : appliedMembers) {
                CPMember cpMember;
                if (endpoint.equals(localCPEndpoint) || (cpMember = this.raftService.getInvocationManager().getCPMember(endpoint)) == null) continue;
                followers.add(cpMember);
            }
            followersMap.put(groupId, followers);
        }
        Set<Member> clusterMembers = this.nodeEngine.getClusterService().getMembers();
        OperationService operationService = this.nodeEngine.getOperationService();
        CPMemberInfo localMember = this.raftService.getLocalCPMember();
        for (Member member : clusterMembers) {
            PublishCPGroupInfoOp op = new PublishCPGroupInfoOp(localMember, followersMap, groupToTerm);
            operationService.executeOrSend("hz:core:raft", op, member.getAddress());
        }
        this.totalPublications.getAndIncrement();
    }

    public void receiveUpdateForLedGroups(CPMember cpLeader, Map<CPGroupId, Set<CPMember>> followerInfo, Map<CPGroupId, Integer> groupTerms) {
        AtomicBoolean changed = new AtomicBoolean();
        for (Map.Entry<CPGroupId, Set<CPMember>> entry2 : followerInfo.entrySet()) {
            if (this.raftService.isRaftGroupDestroyedOrTerminated(entry2.getKey())) continue;
            int term = groupTerms.getOrDefault(entry2.getKey(), 0);
            this.groupIdToState.compute(entry2.getKey(), (id, currentState) -> {
                if (currentState == null || currentState.term <= term) {
                    changed.set(true);
                    return new GroupState(cpLeader, (Set)entry2.getValue(), term);
                }
                return currentState;
            });
        }
        if (this.groupIdToState.entrySet().removeIf(entry -> !followerInfo.containsKey(entry.getKey()) && Objects.equals(((GroupState)entry.getValue()).leader, cpLeader))) {
            changed.set(true);
        }
        if (changed.get()) {
            this.nodeEngine.getNode().getClientEngine().getCPGroupViewListenerService().onGroupViewChange();
        }
    }

    public void receivePreJoinOp(CPGroupsSnapshot cpGroupsSnapshot) {
        this.reset();
        Map<CPGroupId, CPGroupsSnapshot.GroupInfo> infoMap = cpGroupsSnapshot.getAllGroupInformation();
        for (Map.Entry<CPGroupId, CPGroupsSnapshot.GroupInfo> entry : infoMap.entrySet()) {
            if (this.raftService.isRaftGroupDestroyedOrTerminated(entry.getKey())) continue;
            this.groupIdToState.put(entry.getKey(), new GroupState(entry.getValue()));
        }
    }

    public CPGroupsSnapshot createSnapshotView(boolean includeUuidMapping) {
        HashMap<CPGroupId, CPGroupsSnapshot.GroupInfo> newMapping = new HashMap<CPGroupId, CPGroupsSnapshot.GroupInfo>(this.groupIdToState.size());
        HashMap<UUID, UUID> cpToApUuids = includeUuidMapping ? new HashMap<UUID, UUID>() : Collections.emptyMap();
        for (Map.Entry<CPGroupId, GroupState> entry : this.groupIdToState.entrySet()) {
            if (includeUuidMapping) {
                Member apLeader = this.raftService.getClusterMember(entry.getValue().leader);
                if (apLeader == null) continue;
                cpToApUuids.put(entry.getValue().leader.getUuid(), apLeader.getUuid());
            }
            newMapping.put(entry.getKey(), entry.getValue().toGroupInfo());
            if (!includeUuidMapping) continue;
            for (CPMember follower : entry.getValue().followers) {
                Member apMember = this.raftService.getClusterMember(follower);
                if (apMember == null) continue;
                cpToApUuids.put(follower.getUuid(), apMember.getUuid());
            }
        }
        return new CPGroupsSnapshot(newMapping, cpToApUuids);
    }

    public void reset() {
        this.logger.fine("Resetting known CP group view information");
        this.groupIdToState.clear();
    }

    void broadcastStateIfLeader() {
        if (!this.raftService.getLeadedGroups().isEmpty() || this.isLeaderOfAnyLocal()) {
            this.logger.fine("Broadcasting leadership state from periodic task");
            this.publishGroupLeadershipStates();
        } else {
            this.logger.fine("Not broadcasting leadership state as we are not a leader!");
        }
    }

    private boolean isLeaderOfAnyLocal() {
        CPMemberInfo localCPMember = this.raftService.getLocalCPMember();
        return this.groupIdToState.values().stream().anyMatch(state -> state.leader != null && state.leader.equals(localCPMember));
    }

    long getTotalPublications() {
        return this.totalPublications.get();
    }

    private class LeaderBroadcastTask
    implements Runnable {
        private LeaderBroadcastTask() {
        }

        @Override
        public void run() {
            CPGroupViewTracker.this.broadcastStateIfLeader();
        }
    }

    private static class GroupState {
        private final Set<CPMember> followers;
        private final int term;
        private final CPMember leader;

        GroupState(CPMember leader, Set<CPMember> followers, int term) {
            this.leader = leader;
            this.followers = followers;
            this.term = term;
        }

        GroupState(CPGroupsSnapshot.GroupInfo groupInfo) {
            this.leader = groupInfo.leader();
            this.followers = groupInfo.followers();
            this.term = groupInfo.term();
        }

        public CPGroupsSnapshot.GroupInfo toGroupInfo() {
            return new CPGroupsSnapshot.GroupInfo(this.leader, this.followers, this.term);
        }

        public String toString() {
            return "GroupState {term=" + this.term + ", leader=" + String.valueOf(this.leader) + ", followers=" + String.valueOf(this.followers) + "}";
        }
    }
}

