/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal;

import com.hazelcast.cp.CPGroup;
import com.hazelcast.cp.CPMember;
import com.hazelcast.cp.internal.CPGroupSummary;
import com.hazelcast.cp.internal.CPMemberInfo;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.internal.RaftServiceDataSerializerHook;
import com.hazelcast.cp.internal.raft.impl.RaftEndpoint;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;

public final class CPGroupInfo
implements IdentifiedDataSerializable {
    private RaftGroupId id;
    private Set<RaftEndpoint> initialMembers;
    private Set<RaftEndpoint> members;
    private long membersCommitIndex;
    private volatile CPGroup.CPGroupStatus status;

    public CPGroupInfo() {
    }

    public CPGroupInfo(RaftGroupId id, Collection<RaftEndpoint> members) {
        this.id = id;
        this.status = CPGroup.CPGroupStatus.ACTIVE;
        this.initialMembers = Collections.unmodifiableSet(new LinkedHashSet<RaftEndpoint>(members));
        this.members = Collections.unmodifiableSet(new LinkedHashSet<RaftEndpoint>(members));
    }

    CPGroupInfo(CPGroupInfo other) {
        this.id = other.id;
        this.status = other.status;
        this.membersCommitIndex = other.membersCommitIndex;
        this.initialMembers = Collections.unmodifiableSet(new LinkedHashSet<RaftEndpoint>(other.initialMembers));
        this.members = Collections.unmodifiableSet(new LinkedHashSet<RaftEndpoint>(other.members));
    }

    public RaftGroupId id() {
        return this.id;
    }

    public String name() {
        return this.id.getName();
    }

    public int initialMemberCount() {
        return this.initialMembers.size();
    }

    public Collection<RaftEndpoint> members() {
        return this.members;
    }

    public int memberCount() {
        return this.members.size();
    }

    public boolean containsMember(RaftEndpoint member) {
        return this.members.contains(member);
    }

    public Collection<RaftEndpoint> memberImpls() {
        return this.members;
    }

    public Collection<RaftEndpoint> initialMembers() {
        return this.initialMembers;
    }

    public CPGroup.CPGroupStatus status() {
        return this.status;
    }

    boolean setDestroying() {
        if (this.status == CPGroup.CPGroupStatus.DESTROYED) {
            return false;
        }
        this.status = CPGroup.CPGroupStatus.DESTROYING;
        return true;
    }

    boolean setDestroyed() {
        Preconditions.checkState(this.status != CPGroup.CPGroupStatus.ACTIVE, "Cannot destroy " + String.valueOf(this.id) + " because status is: " + String.valueOf((Object)this.status));
        return this.forceSetDestroyed();
    }

    boolean forceSetDestroyed() {
        if (this.status == CPGroup.CPGroupStatus.DESTROYED) {
            return false;
        }
        this.status = CPGroup.CPGroupStatus.DESTROYED;
        return true;
    }

    long getMembersCommitIndex() {
        return this.membersCommitIndex;
    }

    boolean applyMembershipChange(RaftEndpoint leaving, RaftEndpoint joining, long expectedMembersCommitIndex, long newMembersCommitIndex) {
        Preconditions.checkState(this.status == CPGroup.CPGroupStatus.ACTIVE, "Cannot apply membership change of Leave: " + String.valueOf(leaving) + " and Join: " + String.valueOf(joining) + " since status is: " + String.valueOf((Object)this.status));
        if (this.membersCommitIndex != expectedMembersCommitIndex) {
            return false;
        }
        LinkedHashSet<RaftEndpoint> m = new LinkedHashSet<RaftEndpoint>(this.members);
        if (leaving != null) {
            boolean removed = m.remove(leaving);
            assert (removed) : String.valueOf(leaving) + " is not member of " + this.toString();
        }
        if (joining != null) {
            boolean added = m.add(joining);
            assert (added) : String.valueOf(joining) + " is already member of " + this.toString();
        }
        this.members = Collections.unmodifiableSet(m);
        this.membersCommitIndex = newMembersCommitIndex;
        return true;
    }

    CPGroupSummary toSummary(Collection<CPMemberInfo> cpMembers) {
        HashMap<UUID, CPMemberInfo> cpMembersMap = new HashMap<UUID, CPMemberInfo>();
        for (CPMemberInfo cpMember : cpMembers) {
            cpMembersMap.put(cpMember.getUuid(), cpMember);
        }
        ArrayList<CPMember> groupEndpoints = new ArrayList<CPMember>();
        for (RaftEndpoint endpoint : this.members) {
            CPMemberInfo memberInfo = (CPMemberInfo)cpMembersMap.get(endpoint.getUuid());
            if (memberInfo == null) continue;
            groupEndpoints.add(memberInfo);
        }
        if (groupEndpoints.size() != this.members.size()) {
            throw new IllegalStateException("Missing CP member in active CP members: " + String.valueOf(cpMembers) + " for " + String.valueOf(this));
        }
        return new CPGroupSummary(this.id, this.status, this.initialMembers, groupEndpoints);
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.id);
        SerializationUtil.writeCollection(this.initialMembers, out);
        out.writeLong(this.membersCommitIndex);
        SerializationUtil.writeCollection(this.members, out);
        out.writeString(this.status.toString());
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.id = (RaftGroupId)in.readObject();
        int initialMemberCount = in.readInt();
        LinkedHashSet<RaftEndpoint> initialMembers = new LinkedHashSet<RaftEndpoint>();
        for (int i = 0; i < initialMemberCount; ++i) {
            RaftEndpoint member = (RaftEndpoint)in.readObject();
            initialMembers.add(member);
        }
        this.initialMembers = Collections.unmodifiableSet(initialMembers);
        this.membersCommitIndex = in.readLong();
        int memberCount = in.readInt();
        this.members = new LinkedHashSet<RaftEndpoint>(memberCount);
        for (int i = 0; i < memberCount; ++i) {
            RaftEndpoint member = (RaftEndpoint)in.readObject();
            this.members.add(member);
        }
        this.members = Collections.unmodifiableSet(this.members);
        this.status = CPGroup.CPGroupStatus.valueOf(in.readString());
    }

    @Override
    public int getFactoryId() {
        return RaftServiceDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 2;
    }

    public String toString() {
        return "CPGroupInfo{id=" + String.valueOf(this.id) + ", initialMembers=" + String.valueOf(this.initialMembers) + ", membersCommitIndex=" + this.membersCommitIndex + ", members=" + String.valueOf(this.members()) + ", status=" + String.valueOf((Object)this.status) + "}";
    }
}

