/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.core;

import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.spi.annotation.Beta;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;

@Beta
public class Pipelining<E> {
    private final AtomicInteger permits = new AtomicInteger();
    private final List<CompletionStage<E>> futures = new ArrayList<CompletionStage<E>>();
    private Thread thread;

    public Pipelining(int depth) {
        Preconditions.checkPositive(depth, "depth must be positive");
        this.permits.set(depth);
    }

    public List<E> results() throws ExecutionException, InterruptedException {
        ArrayList<E> result = new ArrayList<E>(this.futures.size());
        for (CompletionStage<E> f : this.futures) {
            result.add(f.toCompletableFuture().get());
        }
        return result;
    }

    public CompletionStage<E> add(CompletionStage<E> future) throws InterruptedException {
        Preconditions.checkNotNull(future, "future can't be null");
        this.thread = Thread.currentThread();
        this.down();
        this.futures.add(future);
        future.whenCompleteAsync((response, t) -> this.up(), ConcurrencyUtil.CALLER_RUNS);
        return future;
    }

    private void down() throws InterruptedException {
        int update;
        int current;
        while (!this.permits.compareAndSet(current = this.permits.get(), update = current - 1)) {
        }
        while (this.permits.get() == -1) {
            LockSupport.park();
            if (!Thread.interrupted()) continue;
            throw new InterruptedException();
        }
    }

    private void up() {
        int update;
        int current;
        while (!this.permits.compareAndSet(current = this.permits.get(), update = current + 1)) {
        }
        if (current == -1) {
            LockSupport.unpark(this.thread);
        }
    }
}

