/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.JavaSerializationFilterConfig;
import com.hazelcast.config.UserCodeNamespaceConfig;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class UserCodeNamespacesConfig {
    private boolean enabled;
    private final Map<String, UserCodeNamespaceConfig> namespaceConfigs = new ConcurrentHashMap<String, UserCodeNamespaceConfig>();
    @Nullable
    private JavaSerializationFilterConfig classFilterConfig;

    public UserCodeNamespacesConfig() {
    }

    public UserCodeNamespacesConfig(UserCodeNamespacesConfig config) {
        this.enabled = config.enabled;
        this.namespaceConfigs.putAll(config.namespaceConfigs);
        this.classFilterConfig = config.classFilterConfig;
    }

    public UserCodeNamespacesConfig(boolean enabled, Map<String, UserCodeNamespaceConfig> namespaceConfigs) {
        this.enabled = enabled;
        this.namespaceConfigs.putAll(namespaceConfigs);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public UserCodeNamespacesConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public UserCodeNamespacesConfig addNamespaceConfig(UserCodeNamespaceConfig userCodeNamespaceConfig) {
        this.addNamespaceConfigLocally(userCodeNamespaceConfig);
        return this;
    }

    protected void addNamespaceConfigLocally(UserCodeNamespaceConfig userCodeNamespaceConfig) {
        Objects.requireNonNull(userCodeNamespaceConfig.getName(), "Namespace name cannot be null");
        this.namespaceConfigs.put(userCodeNamespaceConfig.getName(), userCodeNamespaceConfig);
    }

    public UserCodeNamespacesConfig removeNamespaceConfig(String namespace) {
        this.namespaceConfigs.remove(namespace);
        return this;
    }

    Map<String, UserCodeNamespaceConfig> getNamespaceConfigs() {
        return Collections.unmodifiableMap(this.namespaceConfigs);
    }

    @Nullable
    public JavaSerializationFilterConfig getClassFilterConfig() {
        return this.classFilterConfig;
    }

    public void setClassFilterConfig(@Nullable JavaSerializationFilterConfig javaSerializationFilterConfig) {
        this.classFilterConfig = javaSerializationFilterConfig;
    }

    public String toString() {
        return "NamespacesConfig{enabled=" + this.enabled + ", namespaceConfigs=" + String.valueOf(this.namespaceConfigs) + ", classFilterConfig=" + String.valueOf(this.classFilterConfig) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserCodeNamespacesConfig that = (UserCodeNamespacesConfig)o;
        return this.enabled == that.enabled && Objects.equals(this.namespaceConfigs, that.namespaceConfigs) && Objects.equals(this.classFilterConfig, that.classFilterConfig);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.namespaceConfigs, this.classFilterConfig);
    }
}

