/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cp.internal;

import com.hazelcast.client.cp.internal.datastructures.proxy.ClientRaftProxyFactory;
import com.hazelcast.client.impl.clientside.HazelcastClientInstance;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CPSubsystemAddGroupAvailabilityListenerCodec;
import com.hazelcast.client.impl.protocol.codec.CPSubsystemAddMembershipListenerCodec;
import com.hazelcast.client.impl.protocol.codec.CPSubsystemGetCPGroupIdsCodec;
import com.hazelcast.client.impl.protocol.codec.CPSubsystemGetCPObjectInfosCodec;
import com.hazelcast.client.impl.protocol.codec.CPSubsystemRemoveGroupAvailabilityListenerCodec;
import com.hazelcast.client.impl.protocol.codec.CPSubsystemRemoveMembershipListenerCodec;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.EventHandler;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.impl.spi.impl.ListenerMessageCodec;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.CPMap;
import com.hazelcast.cp.CPMember;
import com.hazelcast.cp.CPObjectInfo;
import com.hazelcast.cp.CPSubsystem;
import com.hazelcast.cp.CPSubsystemManagementService;
import com.hazelcast.cp.IAtomicLong;
import com.hazelcast.cp.IAtomicReference;
import com.hazelcast.cp.ICountDownLatch;
import com.hazelcast.cp.ISemaphore;
import com.hazelcast.cp.event.CPGroupAvailabilityEvent;
import com.hazelcast.cp.event.CPGroupAvailabilityListener;
import com.hazelcast.cp.event.CPMembershipEvent;
import com.hazelcast.cp.event.CPMembershipListener;
import com.hazelcast.cp.event.impl.CPGroupAvailabilityEventImpl;
import com.hazelcast.cp.event.impl.CPMembershipEventImpl;
import com.hazelcast.cp.internal.CPObjectInfoImpl;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.lock.FencedLock;
import com.hazelcast.cp.session.CPSessionManagementService;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public class CPSubsystemImpl
implements CPSubsystem,
Consumer<ClientContext> {
    protected final ClientRaftProxyFactory proxyFactory;
    private volatile ClientContext context;

    public CPSubsystemImpl(ClientRaftProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    @Override
    public void accept(ClientContext context) {
        this.context = context;
        this.proxyFactory.init(context);
    }

    @Override
    @Nonnull
    public IAtomicLong getAtomicLong(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving an atomic long instance with a null name is not allowed!");
        return (IAtomicLong)this.proxyFactory.createProxy("hz:raft:atomicLongService", name);
    }

    @Override
    @Nonnull
    public <E> IAtomicReference<E> getAtomicReference(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving an atomic reference instance with a null name is not allowed!");
        return (IAtomicReference)this.proxyFactory.createProxy("hz:raft:atomicRefService", name);
    }

    @Override
    @Nonnull
    public ICountDownLatch getCountDownLatch(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a count down latch instance with a null name is not allowed!");
        return (ICountDownLatch)this.proxyFactory.createProxy("hz:raft:countDownLatchService", name);
    }

    @Override
    @Nonnull
    public FencedLock getLock(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving an fenced lock instance with a null name is not allowed!");
        return (FencedLock)this.proxyFactory.createProxy("hz:raft:lockService", name);
    }

    @Override
    @Nonnull
    public ISemaphore getSemaphore(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a semaphore instance with a null name is not allowed!");
        return (ISemaphore)this.proxyFactory.createProxy("hz:raft:semaphoreService", name);
    }

    @Override
    public CPMember getLocalCPMember() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CPSubsystemManagementService getCPSubsystemManagementService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CPSessionManagementService getCPSessionManagementService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public UUID addMembershipListener(CPMembershipListener listener) {
        return this.context.getListenerService().registerListener(new CPMembershipListenerMessageCodec(), new CPMembershipEventHandler(listener));
    }

    @Override
    public boolean removeMembershipListener(UUID id) {
        return this.context.getListenerService().deregisterListener(id);
    }

    @Override
    public UUID addGroupAvailabilityListener(CPGroupAvailabilityListener listener) {
        return this.context.getListenerService().registerListener(new CPGroupAvailabilityListenerMessageCodec(), new CPGroupAvailabilityEventHandler(listener));
    }

    @Override
    public boolean removeGroupAvailabilityListener(UUID id) {
        return this.context.getListenerService().deregisterListener(id);
    }

    @Override
    public <K, V> CPMap<K, V> getMap(@Nonnull String name) {
        throw new UnsupportedOperationException("CPMap is not included in your license. Please also ensure you are using the enterprise client.");
    }

    protected <K, V> CPMap<K, V> getCpmap(@Nonnull String name) {
        return this.getMap(name);
    }

    @Override
    @Nonnull
    public Collection<CPGroupId> getCPGroupIds() {
        HazelcastClientInstanceImpl client = (HazelcastClientInstanceImpl)this.context.getHazelcastInstance();
        ClientMessage clientMessage = CPSubsystemGetCPGroupIdsCodec.encodeRequest();
        UUID metadataLeader = client.getCPGroupViewService().getLastKnownMetadataLeader();
        ClientInvocation invocation = metadataLeader != null ? new ClientInvocation((HazelcastClientInstance)client, clientMessage, null, metadataLeader) : new ClientInvocation(client, clientMessage, null);
        ClientInvocationFuture future = invocation.invoke();
        try {
            return (Collection)future.thenApplyAsync(cm -> List.copyOf(CPSubsystemGetCPGroupIdsCodec.decodeResponse(cm)), ConcurrencyUtil.CALLER_RUNS).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new HazelcastException("Could not retrieve CP group ids", e);
        }
    }

    @Override
    @Nonnull
    public Iterable<CPObjectInfo> getObjectInfos(@Nonnull CPGroupId groupId, @Nonnull String serviceName) {
        return this.internalGetObjectInfos(groupId, serviceName, false);
    }

    @Override
    @Nonnull
    public Iterable<CPObjectInfo> getTombstoneInfos(@Nonnull CPGroupId groupId, @Nonnull String serviceName) {
        return this.internalGetObjectInfos(groupId, serviceName, true);
    }

    private List<CPObjectInfo> internalGetObjectInfos(CPGroupId groupId, String serviceName, boolean tombstone) {
        ClientMessage clientMessage = CPSubsystemGetCPObjectInfosCodec.encodeRequest((RaftGroupId)groupId, serviceName, tombstone);
        ClientInvocation invocation = new ClientInvocation((HazelcastClientInstanceImpl)this.context.getHazelcastInstance(), clientMessage, null);
        ClientInvocationFuture future = invocation.invoke();
        try {
            return ((List)future.thenApplyAsync(CPSubsystemGetCPObjectInfosCodec::decodeResponse, ConcurrencyUtil.CALLER_RUNS).get()).stream().map(name -> new CPObjectInfoImpl((String)name, serviceName, groupId)).toList();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new HazelcastException("Could not retrieve CP object infos", e);
        }
    }

    private static class CPMembershipListenerMessageCodec
    implements ListenerMessageCodec {
        private CPMembershipListenerMessageCodec() {
        }

        @Override
        public ClientMessage encodeAddRequest(boolean localOnly) {
            return CPSubsystemAddMembershipListenerCodec.encodeRequest(localOnly);
        }

        @Override
        public UUID decodeAddResponse(ClientMessage clientMessage) {
            return CPSubsystemAddMembershipListenerCodec.decodeResponse(clientMessage);
        }

        @Override
        public ClientMessage encodeRemoveRequest(UUID realRegistrationId) {
            return CPSubsystemRemoveMembershipListenerCodec.encodeRequest(realRegistrationId);
        }

        @Override
        public boolean decodeRemoveResponse(ClientMessage clientMessage) {
            return CPSubsystemRemoveMembershipListenerCodec.decodeResponse(clientMessage);
        }
    }

    private static class CPMembershipEventHandler
    extends CPSubsystemAddMembershipListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final CPMembershipListener listener;

        CPMembershipEventHandler(CPMembershipListener listener) {
            this.listener = listener;
        }

        @Override
        public void handleMembershipEventEvent(CPMember member, byte type) {
            CPMembershipEventImpl event = new CPMembershipEventImpl(member, type);
            if (event.getType() == CPMembershipEvent.EventType.ADDED) {
                this.listener.memberAdded(event);
            } else {
                this.listener.memberRemoved(event);
            }
        }
    }

    private static class CPGroupAvailabilityListenerMessageCodec
    implements ListenerMessageCodec {
        private CPGroupAvailabilityListenerMessageCodec() {
        }

        @Override
        public ClientMessage encodeAddRequest(boolean localOnly) {
            return CPSubsystemAddGroupAvailabilityListenerCodec.encodeRequest(localOnly);
        }

        @Override
        public UUID decodeAddResponse(ClientMessage clientMessage) {
            return CPSubsystemAddGroupAvailabilityListenerCodec.decodeResponse(clientMessage);
        }

        @Override
        public ClientMessage encodeRemoveRequest(UUID realRegistrationId) {
            return CPSubsystemRemoveGroupAvailabilityListenerCodec.encodeRequest(realRegistrationId);
        }

        @Override
        public boolean decodeRemoveResponse(ClientMessage clientMessage) {
            return CPSubsystemRemoveGroupAvailabilityListenerCodec.decodeResponse(clientMessage);
        }
    }

    private static class CPGroupAvailabilityEventHandler
    extends CPSubsystemAddGroupAvailabilityListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private static final long DEDUPLICATION_PERIOD = TimeUnit.MINUTES.toMillis(1L);
        private final CPGroupAvailabilityListener listener;
        private final Map<CPGroupAvailabilityEvent, Long> recentEvents = new ConcurrentHashMap<CPGroupAvailabilityEvent, Long>();

        CPGroupAvailabilityEventHandler(CPGroupAvailabilityListener listener) {
            this.listener = listener;
        }

        @Override
        public void handleGroupAvailabilityEventEvent(RaftGroupId groupId, Collection<CPMember> members, Collection<CPMember> unavailableMembers, boolean isIsShutdownExists, boolean isShutdown) {
            boolean isShutdownValue = isIsShutdownExists && isShutdown;
            this.handleGroupAvailabilityEventEvent(groupId, members, unavailableMembers, isShutdownValue);
        }

        public void handleGroupAvailabilityEventEvent(RaftGroupId groupId, Collection<CPMember> members, Collection<CPMember> unavailableMembers, boolean isShutdown) {
            long now = Clock.currentTimeMillis();
            this.recentEvents.values().removeIf(expirationTime -> expirationTime < now);
            CPGroupAvailabilityEventImpl event = new CPGroupAvailabilityEventImpl(groupId, members, unavailableMembers, isShutdown);
            if (this.recentEvents.putIfAbsent(event, now + DEDUPLICATION_PERIOD) != null) {
                return;
            }
            if (event.isMajorityAvailable()) {
                this.listener.availabilityDecreased(event);
            } else {
                this.listener.majorityLost(event);
            }
        }
    }
}

