/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.wan;

import com.hazelcast.cache.impl.wan.WanEnterpriseCacheEvent;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.SerializationServiceAware;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.wan.WanEventCounters;
import com.hazelcast.wan.WanEventType;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WanEnterpriseCacheRemoveEvent
extends WanEnterpriseCacheEvent<Object>
implements SerializationServiceAware {
    private SerializationService serializationService;
    private Data dataKey;
    private transient Object key;

    public WanEnterpriseCacheRemoveEvent(@Nonnull String cacheName, @Nonnull Data dataKey, @Nonnull String managerPrefix, int backupCount, @Nonnull SerializationService serializationService) {
        super(cacheName, managerPrefix, backupCount);
        this.serializationService = serializationService;
        this.dataKey = dataKey;
    }

    public WanEnterpriseCacheRemoveEvent() {
    }

    @Override
    @Nonnull
    public Data getKey() {
        return this.dataKey;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        IOUtil.writeData(out, this.dataKey);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.dataKey = IOUtil.readData(in);
    }

    @Override
    public int getClassId() {
        return 7;
    }

    @Override
    public void incrementEventCount(@Nonnull WanEventCounters counters) {
        counters.incrementRemove(this.getCacheName());
    }

    @Override
    @Nonnull
    public WanEventType getEventType() {
        return WanEventType.REMOVE;
    }

    @Override
    @Nullable
    public Object getEventObject() {
        if (this.key == null) {
            this.key = this.serializationService.toObject(this.dataKey);
        }
        return this.key;
    }

    @Override
    public void setSerializationService(SerializationService serializationService) {
        this.serializationService = serializationService;
    }
}

