/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.operation;

import com.hazelcast.cache.impl.CacheMergeResponse;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.operation.CacheOperation;
import com.hazelcast.cache.impl.operation.CachePutAllBackupOperation;
import com.hazelcast.internal.namespace.NamespaceUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.BackupAwareOperation;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergeTypes;
import com.hazelcast.wan.impl.CallerProvenance;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class CacheMergeOperation
extends CacheOperation
implements BackupAwareOperation {
    private List<SplitBrainMergeTypes.CacheMergeTypes<Object, Object>> mergingEntries;
    private SplitBrainMergePolicy<Object, SplitBrainMergeTypes.CacheMergeTypes<Object, Object>, Object> mergePolicy;
    private transient boolean hasBackups;
    private transient List backupPairs;
    private transient BitSet backupNonReplicatedKeys;

    public CacheMergeOperation() {
    }

    public CacheMergeOperation(String name, List<SplitBrainMergeTypes.CacheMergeTypes<Object, Object>> mergingEntries, SplitBrainMergePolicy<Object, SplitBrainMergeTypes.CacheMergeTypes<Object, Object>, Object> mergePolicy) {
        super(name);
        this.mergingEntries = mergingEntries;
        this.mergePolicy = mergePolicy;
    }

    @Override
    protected void beforeRunInternal() {
        boolean bl = this.hasBackups = this.getSyncBackupCount() + this.getAsyncBackupCount() > 0;
        if (this.hasBackups) {
            this.backupPairs = new ArrayList(this.mergingEntries.size());
            this.backupNonReplicatedKeys = new BitSet(this.mergingEntries.size());
        }
    }

    @Override
    public void run() {
        for (SplitBrainMergeTypes.CacheMergeTypes<Object, Object> mergingEntry : this.mergingEntries) {
            this.merge(mergingEntry);
        }
    }

    private void merge(SplitBrainMergeTypes.CacheMergeTypes<Object, Object> mergingEntry) {
        Data dataKey = (Data)mergingEntry.getRawKey();
        CacheMergeResponse response = this.recordStore.merge(mergingEntry, this.mergePolicy, CallerProvenance.NOT_WAN);
        if (this.backupPairs != null && response.getResult().isMergeApplied()) {
            if (response.getResult() == CacheMergeResponse.MergeResult.RECORDS_ARE_EQUAL) {
                this.backupNonReplicatedKeys.set(this.backupPairs.size() / 2);
            }
            this.backupPairs.add(dataKey);
            this.backupPairs.add(response.getRecord());
        }
        if (this.recordStore.isWanReplicationEnabled()) {
            if (response.getResult().isMergeApplied()) {
                if (response.getResult() != CacheMergeResponse.MergeResult.RECORDS_ARE_EQUAL) {
                    this.publishWanUpdate(dataKey, response.getRecord());
                }
            } else {
                this.publishWanRemove(dataKey);
            }
        }
    }

    @Override
    public Object getResponse() {
        return this.hasBackups && !this.backupPairs.isEmpty();
    }

    @Override
    public boolean shouldBackup() {
        return this.hasBackups && !this.backupPairs.isEmpty();
    }

    @Override
    public Operation getBackupOperation() {
        return new CachePutAllBackupOperation(this.name, this.backupPairs, this.backupNonReplicatedKeys);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.mergingEntries.size());
        for (SplitBrainMergeTypes.CacheMergeTypes<Object, Object> mergingEntry : this.mergingEntries) {
            out.writeObject(mergingEntry);
        }
        out.writeObject(this.mergePolicy);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.mergingEntries = SerializationUtil.readList(in);
        this.mergePolicy = NamespaceUtil.callWithNamespace(in::readObject, this.name, CacheService::lookupNamespace);
    }

    @Override
    public int getClassId() {
        return 61;
    }
}

