/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.hidensity.operation;

import com.hazelcast.cache.impl.hidensity.HiDensityCacheRecordStore;
import com.hazelcast.cache.impl.hidensity.operation.KeyBasedHiDensityCacheOperation;
import com.hazelcast.cache.impl.operation.MutableOperation;
import com.hazelcast.cache.impl.record.CacheRecord;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import java.io.IOException;
import javax.cache.expiry.ExpiryPolicy;

public class CachePutBackupOperation
extends KeyBasedHiDensityCacheOperation
implements BackupOperation,
MutableOperation {
    private Data value;
    private ExpiryPolicy expiryPolicy;
    private boolean wanOriginated;
    private long creationTime = -1L;
    private transient CacheRecord record;

    public CachePutBackupOperation() {
    }

    public CachePutBackupOperation(String name, Data key, Data value, ExpiryPolicy expiryPolicy, long creationTime) {
        super(name, key);
        this.value = value;
        this.expiryPolicy = expiryPolicy;
        this.creationTime = creationTime;
    }

    public CachePutBackupOperation(String name, Data key, Data value, ExpiryPolicy expiryPolicy, long creationTime, boolean wanOriginated) {
        this(name, key, value, expiryPolicy, creationTime);
        this.wanOriginated = wanOriginated;
    }

    @Override
    public void runInternal() {
        if (this.recordStore == null) {
            return;
        }
        HiDensityCacheRecordStore hdCache = (HiDensityCacheRecordStore)this.recordStore;
        this.record = hdCache.putBackup(this.key, this.value, this.creationTime, this.expiryPolicy);
        this.response = Boolean.TRUE;
    }

    @Override
    public void afterRun() throws Exception {
        if (!this.wanOriginated) {
            this.publishWanUpdate(this.key, this.record);
        }
        super.afterRun();
    }

    @Override
    protected void disposeInternal(EnterpriseSerializationService serializationService) {
        if (!this.runCompleted) {
            serializationService.disposeData(this.key);
            serializationService.disposeData(this.value);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.expiryPolicy);
        IOUtil.writeData(out, this.value);
        out.writeBoolean(this.wanOriginated);
        out.writeLong(this.creationTime);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.expiryPolicy = (ExpiryPolicy)in.readObject();
        this.value = CachePutBackupOperation.readNativeMemoryOperationData(in);
        this.wanOriginated = in.readBoolean();
        this.creationTime = in.readLong();
    }

    @Override
    public int getClassId() {
        return 8;
    }
}

