/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.hidensity.operation;

import com.hazelcast.cache.impl.hidensity.HiDensityCacheRecordStore;
import com.hazelcast.cache.impl.hidensity.operation.CacheBackupRecordStore;
import com.hazelcast.cache.impl.hidensity.operation.HiDensityCacheDataSerializerHook;
import com.hazelcast.cache.impl.hidensity.operation.HiDensityCacheOperation;
import com.hazelcast.cache.impl.operation.MutableOperation;
import com.hazelcast.cache.impl.record.CacheRecord;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.cache.expiry.ExpiryPolicy;

public class CachePutAllBackupOperation
extends HiDensityCacheOperation
implements BackupOperation,
MutableOperation {
    private CacheBackupRecordStore cacheBackupRecordStore;
    private ExpiryPolicy expiryPolicy;

    public CachePutAllBackupOperation() {
    }

    public CachePutAllBackupOperation(String name, CacheBackupRecordStore cacheBackupRecordStore, ExpiryPolicy expiryPolicy) {
        super(name);
        this.cacheBackupRecordStore = cacheBackupRecordStore;
        this.expiryPolicy = expiryPolicy;
    }

    @Override
    protected void runInternal() {
        if (this.recordStore == null) {
            return;
        }
        List<CacheBackupRecordStore.CacheBackupRecord> cacheBackupRecords = this.cacheBackupRecordStore.backupRecords;
        HiDensityCacheRecordStore hdCache = (HiDensityCacheRecordStore)this.recordStore;
        Iterator<CacheBackupRecordStore.CacheBackupRecord> iter2 = cacheBackupRecords.iterator();
        while (iter2.hasNext()) {
            CacheBackupRecordStore.CacheBackupRecord cacheBackupRecord = iter2.next();
            CacheRecord record = hdCache.putBackup(cacheBackupRecord.key, cacheBackupRecord.value, cacheBackupRecord.creationTime, this.expiryPolicy);
            this.publishWanUpdate(cacheBackupRecord.key, record);
            iter2.remove();
        }
    }

    @Override
    protected void disposeInternal(EnterpriseSerializationService serializationService) {
        List<CacheBackupRecordStore.CacheBackupRecord> cacheBackupRecords = this.cacheBackupRecordStore.backupRecords;
        Iterator<CacheBackupRecordStore.CacheBackupRecord> iter2 = cacheBackupRecords.iterator();
        while (iter2.hasNext()) {
            CacheBackupRecordStore.CacheBackupRecord cacheBackupRecord = iter2.next();
            serializationService.disposeData(cacheBackupRecord.key);
            serializationService.disposeData(cacheBackupRecord.value);
            iter2.remove();
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.expiryPolicy);
        List<CacheBackupRecordStore.CacheBackupRecord> cacheBackupRecords = this.cacheBackupRecordStore.backupRecords;
        out.writeInt(cacheBackupRecords != null ? cacheBackupRecords.size() : 0);
        if (cacheBackupRecords != null) {
            for (CacheBackupRecordStore.CacheBackupRecord cacheBackupRecord : cacheBackupRecords) {
                IOUtil.writeData(out, cacheBackupRecord.key);
                IOUtil.writeData(out, cacheBackupRecord.value);
                out.writeLong(cacheBackupRecord.creationTime);
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.expiryPolicy = (ExpiryPolicy)in.readObject();
        int size = in.readInt();
        if (size > 0) {
            this.cacheBackupRecordStore = new CacheBackupRecordStore(size);
            for (int i = 0; i < size; ++i) {
                Data key = HiDensityCacheOperation.readNativeMemoryOperationData(in);
                Data value = HiDensityCacheOperation.readNativeMemoryOperationData(in);
                long creationTime = in.readLong();
                this.cacheBackupRecordStore.addBackupRecord(key, value, creationTime);
            }
        }
    }

    @Override
    public int getClassId() {
        return 9;
    }

    @Override
    public int getFactoryId() {
        return HiDensityCacheDataSerializerHook.F_ID;
    }
}

