/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.hidensity.operation;

import com.hazelcast.cache.impl.CacheMergeResponse;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.hidensity.operation.BackupAwareHiDensityCacheOperation;
import com.hazelcast.cache.impl.hidensity.operation.CacheMergeBackupOperation;
import com.hazelcast.cache.impl.operation.MutableOperation;
import com.hazelcast.internal.namespace.NamespaceUtil;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.merge.CacheMergingEntryImpl;
import com.hazelcast.spi.impl.operationservice.MutatingOperation;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergeTypes;
import com.hazelcast.wan.impl.CallerProvenance;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class CacheMergeOperation
extends BackupAwareHiDensityCacheOperation
implements MutableOperation,
MutatingOperation {
    private SplitBrainMergePolicy<Object, SplitBrainMergeTypes.CacheMergeTypes<Object, Object>, Object> mergePolicy;
    private List<SplitBrainMergeTypes.CacheMergeTypes<Object, Object>> mergingEntries;
    private transient boolean hasBackups;
    private transient boolean wanReplicationEnabled;
    private transient List backupPairs;
    private transient BitSet nonWanReplicatedKeys;

    public CacheMergeOperation() {
    }

    public CacheMergeOperation(String name, List<SplitBrainMergeTypes.CacheMergeTypes<Object, Object>> mergingEntries, SplitBrainMergePolicy<Object, SplitBrainMergeTypes.CacheMergeTypes<Object, Object>, Object> policy) {
        super(name);
        this.mergingEntries = mergingEntries;
        this.mergePolicy = policy;
    }

    @Override
    public void beforeRunInternal() {
        this.wanReplicationEnabled = this.recordStore.isWanReplicationEnabled();
        boolean bl = this.hasBackups = this.getSyncBackupCount() + this.getAsyncBackupCount() > 0;
        if (this.hasBackups) {
            this.backupPairs = new ArrayList(this.mergingEntries.size() * 2);
            this.nonWanReplicatedKeys = new BitSet(this.mergingEntries.size());
        }
    }

    @Override
    public void runInternal() {
        for (SplitBrainMergeTypes.CacheMergeTypes<Object, Object> mergingEntry : this.mergingEntries) {
            this.merge(mergingEntry);
        }
        this.response = true;
    }

    private void merge(SplitBrainMergeTypes.CacheMergeTypes mergingEntry) {
        assert (mergingEntry instanceof CacheMergingEntryImpl);
        CacheMergingEntryImpl mergingEntryImpl = (CacheMergingEntryImpl)mergingEntry;
        CacheMergeResponse response = this.recordStore.merge(mergingEntry, this.mergePolicy, CallerProvenance.NOT_WAN);
        if (this.hasBackups && response.getResult().isMergeApplied()) {
            if (response.getResult() == CacheMergeResponse.MergeResult.RECORDS_ARE_EQUAL) {
                this.nonWanReplicatedKeys.set(this.backupPairs.size() / 2);
            }
            this.backupPairs.add(mergingEntryImpl.getRawKey());
            this.backupPairs.add(response.getRecord());
        }
        if (this.wanReplicationEnabled) {
            if (response.getResult().isMergeApplied()) {
                if (response.getResult() != CacheMergeResponse.MergeResult.RECORDS_ARE_EQUAL) {
                    this.publishWanUpdate(mergingEntryImpl.getRawKey(), response.getRecord());
                }
            } else {
                this.publishWanRemove(mergingEntryImpl.getRawKey());
            }
        }
    }

    @Override
    public boolean shouldBackup() {
        return this.hasBackups && !this.backupPairs.isEmpty();
    }

    @Override
    public Operation getBackupOperation() {
        return new CacheMergeBackupOperation(this.name, this.backupPairs, this.nonWanReplicatedKeys);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        SerializationUtil.writeList(this.mergingEntries, out);
        out.writeObject(this.mergePolicy);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.mergingEntries = SerializationUtil.readList(in);
        this.mergePolicy = NamespaceUtil.callWithNamespace(in::readObject, this.name, CacheService::lookupNamespace);
    }

    @Override
    public int getClassId() {
        return 24;
    }
}

