/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.hidensity.maxsize;

import com.hazelcast.internal.eviction.EvictionChecker;
import com.hazelcast.internal.memory.HazelcastMemoryManager;
import com.hazelcast.memory.MemoryUnit;

public class HiDensityFreeNativeMemorySizeEvictionChecker
implements EvictionChecker {
    private final HazelcastMemoryManager memoryManager;
    private final long minFreeMemorySize;

    public HiDensityFreeNativeMemorySizeEvictionChecker(HazelcastMemoryManager memoryManager, int size) {
        this.memoryManager = memoryManager;
        this.minFreeMemorySize = MemoryUnit.BYTES.convert(size, MemoryUnit.MEGABYTES);
    }

    @Override
    public boolean isEvictionRequired() {
        return this.memoryManager.getMemoryStats().getFreeNative() < this.minFreeMemorySize;
    }
}

