/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.web;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.web.WebDataSerializerHook;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class SessionState
implements IdentifiedDataSerializable {
    @Nonnull
    private final Map<String, Data> attributes = new HashMap<String, Data>(1);

    public int getFactoryId() {
        return WebDataSerializerHook.F_ID;
    }

    public int getClassId() {
        return 6;
    }

    public Map<String, Data> getAttributes() {
        return this.attributes;
    }

    public void setAttribute(String key, Data value) {
        this.attributes.put(key, value);
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.attributes.size());
        for (Map.Entry<String, Data> entry : this.attributes.entrySet()) {
            out.writeString(entry.getKey());
            IOUtil.writeData((ObjectDataOutput)out, (Data)entry.getValue());
        }
    }

    public void readData(ObjectDataInput in) throws IOException {
        int attCount = in.readInt();
        for (int i = 0; i < attCount; ++i) {
            this.attributes.put(in.readString(), IOUtil.readData((ObjectDataInput)in));
        }
    }

    public void set(Map<String, Data> attributes) {
        Objects.requireNonNull(attributes, "attributes should not be null, please report a bug if you got this error");
        this.attributes.putAll(attributes);
    }

    public String toString() {
        Objects.requireNonNull(this.attributes, "attributes should not be null, please report a bug if you got this error");
        StringBuilder sb = new StringBuilder("SessionState {");
        sb.append(", attributes=").append(this.attributes.size());
        for (Map.Entry<String, Data> entry : this.attributes.entrySet()) {
            Data data = entry.getValue();
            int len = data == null ? 0 : data.dataSize();
            sb.append("\n\t");
            sb.append(entry.getKey()).append("[").append(len).append("]");
        }
        sb.append("\n}");
        return sb.toString();
    }
}

