/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client.reactive;

import java.net.URI;
import java.net.http.HttpRequest;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Flow;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.reactive.AbstractClientHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import reactor.adapter.JdkFlowAdapter;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class JdkClientHttpRequest
extends AbstractClientHttpRequest {
    private final HttpMethod method;
    private final URI uri;
    private final DataBufferFactory bufferFactory;
    private final HttpRequest.Builder builder;

    public JdkClientHttpRequest(HttpMethod httpMethod, URI uri, DataBufferFactory bufferFactory, @Nullable Duration readTimeout) {
        Assert.notNull((Object)httpMethod, "HttpMethod is required");
        Assert.notNull((Object)uri, "URI is required");
        Assert.notNull((Object)bufferFactory, "DataBufferFactory is required");
        this.method = httpMethod;
        this.uri = uri;
        this.bufferFactory = bufferFactory;
        this.builder = HttpRequest.newBuilder(uri);
        if (readTimeout != null) {
            this.builder.timeout(readTimeout);
        }
    }

    @Override
    public HttpMethod getMethod() {
        return this.method;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public DataBufferFactory bufferFactory() {
        return this.bufferFactory;
    }

    @Override
    public <T> T getNativeRequest() {
        return (T)this.builder.build();
    }

    @Override
    protected void applyHeaders() {
        for (Map.Entry<String, List<String>> entry : this.getHeaders().entrySet()) {
            if (entry.getKey().equalsIgnoreCase("Content-Length")) continue;
            for (String value : entry.getValue()) {
                this.builder.header(entry.getKey(), value);
            }
        }
        if (!this.getHeaders().containsKey("Accept")) {
            this.builder.header("Accept", "*/*");
        }
    }

    @Override
    protected void applyCookies() {
        MultiValueMap<String, HttpCookie> cookies = this.getCookies();
        if (cookies.isEmpty()) {
            return;
        }
        this.builder.header("Cookie", cookies.values().stream().flatMap(Collection::stream).map(HttpCookie::toString).collect(Collectors.joining(";")));
    }

    @Override
    public Mono<Void> writeWith(Publisher<? extends DataBuffer> body2) {
        return this.doCommit(() -> {
            this.builder.method(this.method.name(), this.toBodyPublisher(body2));
            return Mono.empty();
        });
    }

    private HttpRequest.BodyPublisher toBodyPublisher(Publisher<? extends DataBuffer> body2) {
        Mono byteBufferBody = body2 instanceof Mono ? Mono.from(body2).map(this::toByteBuffer) : Flux.from(body2).map(this::toByteBuffer);
        Flow.Publisher bodyFlow = JdkFlowAdapter.publisherToFlowPublisher((Publisher)byteBufferBody);
        return this.getHeaders().getContentLength() > 0L ? HttpRequest.BodyPublishers.fromPublisher(bodyFlow, this.getHeaders().getContentLength()) : HttpRequest.BodyPublishers.fromPublisher(bodyFlow);
    }

    private ByteBuffer toByteBuffer(DataBuffer dataBuffer) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(dataBuffer.readableByteCount());
        dataBuffer.toByteBuffer(byteBuffer);
        return byteBuffer;
    }

    @Override
    public Mono<Void> writeAndFlushWith(Publisher<? extends Publisher<? extends DataBuffer>> body2) {
        return this.writeWith((Publisher<? extends DataBuffer>)Flux.from(body2).flatMap(Function.identity()));
    }

    @Override
    public Mono<Void> setComplete() {
        return this.doCommit(() -> {
            this.builder.method(this.method.name(), HttpRequest.BodyPublishers.noBody());
            return Mono.empty();
        });
    }
}

