/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.LifeCycle;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.springframework.util.Assert;

class LogbackConfigurator {
    private final LoggerContext context;

    LogbackConfigurator(LoggerContext context) {
        Assert.notNull((Object)context, "'context' must not be null");
        this.context = context;
    }

    LoggerContext getContext() {
        return this.context;
    }

    ReentrantLock getConfigurationLock() {
        return this.context.getConfigurationLock();
    }

    <T extends Converter<?>> void conversionRule(String conversionWord, Class<T> converterClass, Supplier<T> converterSupplier) {
        Assert.hasLength(conversionWord, "'conversionWord' must not be empty");
        Assert.notNull(converterSupplier, "'converterSupplier' must not be null");
        HashMap<String, Supplier<T>> registry = (HashMap<String, Supplier<T>>)this.context.getObject("PATTERN_RULE_REGISTRY_FOR_SUPPLIERS");
        if (registry == null) {
            registry = new HashMap<String, Supplier<T>>();
            this.context.putObject("PATTERN_RULE_REGISTRY_FOR_SUPPLIERS", registry);
        }
        registry.put(conversionWord, converterSupplier);
    }

    void appender(String name, Appender<?> appender) {
        appender.setName(name);
        this.start((LifeCycle)appender);
    }

    void logger(String name, Level level) {
        this.logger(name, level, true);
    }

    void logger(String name, Level level, boolean additive) {
        this.logger(name, level, additive, null);
    }

    void logger(String name, Level level, boolean additive, Appender<ILoggingEvent> appender) {
        Logger logger2 = this.context.getLogger(name);
        if (level != null) {
            logger2.setLevel(level);
        }
        logger2.setAdditive(additive);
        if (appender != null) {
            logger2.addAppender(appender);
        }
    }

    @SafeVarargs
    final void root(Level level, Appender<ILoggingEvent> ... appenders) {
        Logger logger2 = this.context.getLogger("ROOT");
        if (level != null) {
            logger2.setLevel(level);
        }
        for (Appender<ILoggingEvent> appender : appenders) {
            logger2.addAppender(appender);
        }
    }

    void start(LifeCycle lifeCycle) {
        if (lifeCycle instanceof ContextAware) {
            ContextAware contextAware = (ContextAware)lifeCycle;
            contextAware.setContext((Context)this.context);
        }
        lifeCycle.start();
    }
}

