/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.reactive.error;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.template.TemplateAvailabilityProviders;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.reactive.error.ErrorAttributes;
import org.springframework.boot.web.reactive.error.ErrorWebExceptionHandler;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.log.LogMessage;
import org.springframework.http.HttpLogging;
import org.springframework.http.HttpStatus;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.reactive.result.view.ViewResolver;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.DisconnectedClientHelper;
import org.springframework.web.util.HtmlUtils;
import reactor.core.publisher.Mono;

public abstract class AbstractErrorWebExceptionHandler
implements ErrorWebExceptionHandler,
InitializingBean {
    private static final Log logger = HttpLogging.forLogName(AbstractErrorWebExceptionHandler.class);
    private final ApplicationContext applicationContext;
    private final ErrorAttributes errorAttributes;
    private final WebProperties.Resources resources;
    private final TemplateAvailabilityProviders templateAvailabilityProviders;
    private List<HttpMessageReader<?>> messageReaders = Collections.emptyList();
    private List<HttpMessageWriter<?>> messageWriters = Collections.emptyList();
    private List<ViewResolver> viewResolvers = Collections.emptyList();

    public AbstractErrorWebExceptionHandler(ErrorAttributes errorAttributes, WebProperties.Resources resources, ApplicationContext applicationContext) {
        Assert.notNull((Object)errorAttributes, "'errorAttributes' must not be null");
        Assert.notNull((Object)resources, "'resources' must not be null");
        Assert.notNull((Object)applicationContext, "'applicationContext' must not be null");
        this.errorAttributes = errorAttributes;
        this.resources = resources;
        this.applicationContext = applicationContext;
        this.templateAvailabilityProviders = new TemplateAvailabilityProviders(applicationContext);
    }

    public void setMessageWriters(List<HttpMessageWriter<?>> messageWriters) {
        Assert.notNull(messageWriters, "'messageWriters' must not be null");
        this.messageWriters = messageWriters;
    }

    public void setMessageReaders(List<HttpMessageReader<?>> messageReaders) {
        Assert.notNull(messageReaders, "'messageReaders' must not be null");
        this.messageReaders = messageReaders;
    }

    public void setViewResolvers(List<ViewResolver> viewResolvers) {
        this.viewResolvers = viewResolvers;
    }

    protected Map<String, Object> getErrorAttributes(ServerRequest request, ErrorAttributeOptions options) {
        return this.errorAttributes.getErrorAttributes(request, options);
    }

    protected Throwable getError(ServerRequest request) {
        return this.errorAttributes.getError(request);
    }

    protected boolean isTraceEnabled(ServerRequest request) {
        return this.getBooleanParameter(request, "trace");
    }

    protected boolean isMessageEnabled(ServerRequest request) {
        return this.getBooleanParameter(request, "message");
    }

    protected boolean isBindingErrorsEnabled(ServerRequest request) {
        return this.getBooleanParameter(request, "errors");
    }

    protected boolean isPathEnabled(ServerRequest request) {
        return this.getBooleanParameter(request, "path");
    }

    private boolean getBooleanParameter(ServerRequest request, String parameterName) {
        String parameter = request.queryParam(parameterName).orElse("false");
        return !"false".equalsIgnoreCase(parameter);
    }

    protected Mono<ServerResponse> renderErrorView(String viewName, ServerResponse.BodyBuilder responseBody, Map<String, Object> error) {
        if (this.isTemplateAvailable(viewName)) {
            return responseBody.render(viewName, error);
        }
        Resource resource = this.resolveResource(viewName);
        if (resource != null) {
            return responseBody.body(BodyInserters.fromResource((Resource)resource));
        }
        return Mono.empty();
    }

    private boolean isTemplateAvailable(String viewName) {
        return this.templateAvailabilityProviders.getProvider(viewName, this.applicationContext) != null;
    }

    private Resource resolveResource(String viewName) {
        for (String location : this.resources.getStaticLocations()) {
            try {
                Resource resource = this.applicationContext.getResource(location);
                resource = resource.createRelative(viewName + ".html");
                if (!resource.exists()) continue;
                return resource;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected Mono<ServerResponse> renderDefaultErrorView(ServerResponse.BodyBuilder responseBody, Map<String, Object> error) {
        StringBuilder builder = new StringBuilder();
        Date timestamp = (Date)error.get("timestamp");
        Object message = error.get("message");
        Object trace = error.get("trace");
        Object requestId = error.get("requestId");
        builder.append("<html><body><h1>Whitelabel Error Page</h1>").append("<p>This application has no configured error view, so you are seeing this as a fallback.</p>").append("<div id='created'>").append(timestamp).append("</div>").append("<div>[").append(requestId).append("] There was an unexpected error (type=").append(this.htmlEscape(error.get("error"))).append(", status=").append(this.htmlEscape(error.get("status"))).append(").</div>");
        if (message != null) {
            builder.append("<div>").append(this.htmlEscape(message)).append("</div>");
        }
        if (trace != null) {
            builder.append("<div style='white-space:pre-wrap;'>").append(this.htmlEscape(trace)).append("</div>");
        }
        builder.append("</body></html>");
        return responseBody.bodyValue((Object)builder.toString());
    }

    private String htmlEscape(Object input) {
        return input != null ? HtmlUtils.htmlEscape(input.toString()) : null;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (CollectionUtils.isEmpty(this.messageWriters)) {
            throw new IllegalArgumentException("Property 'messageWriters' is required");
        }
    }

    protected abstract RouterFunction<ServerResponse> getRoutingFunction(ErrorAttributes var1);

    @Override
    public Mono<Void> handle(ServerWebExchange exchange2, Throwable throwable) {
        if (exchange2.getResponse().isCommitted() || this.isDisconnectedClientError(throwable)) {
            return Mono.error((Throwable)throwable);
        }
        this.errorAttributes.storeErrorInformation(throwable, exchange2);
        ServerRequest request = ServerRequest.create((ServerWebExchange)exchange2, this.messageReaders);
        return this.getRoutingFunction(this.errorAttributes).route(request).switchIfEmpty(Mono.error((Throwable)throwable)).flatMap(handler -> handler.handle(request)).doOnNext(response -> this.logError(request, (ServerResponse)response, throwable)).flatMap(response -> this.write(exchange2, (ServerResponse)response));
    }

    private boolean isDisconnectedClientError(Throwable ex) {
        return DisconnectedClientHelper.isClientDisconnectedException(ex);
    }

    protected void logError(ServerRequest request, ServerResponse response, Throwable throwable) {
        if (logger.isDebugEnabled()) {
            logger.debug(request.exchange().getLogPrefix() + this.formatError(throwable, request));
        }
        if (HttpStatus.resolve(response.statusCode().value()) != null && response.statusCode().equals(HttpStatus.INTERNAL_SERVER_ERROR)) {
            logger.error(LogMessage.of(() -> String.format("%s 500 Server Error for %s", request.exchange().getLogPrefix(), this.formatRequest(request))), throwable);
        }
    }

    private String formatError(Throwable ex, ServerRequest request) {
        String reason = ex.getClass().getSimpleName() + ": " + ex.getMessage();
        return "Resolved [" + reason + "] for HTTP " + String.valueOf(request.method()) + " " + request.path();
    }

    private String formatRequest(ServerRequest request) {
        String rawQuery = request.uri().getRawQuery();
        Object query = StringUtils.hasText(rawQuery) ? "?" + rawQuery : "";
        return "HTTP " + String.valueOf(request.method()) + " \"" + request.path() + (String)query + "\"";
    }

    private Mono<? extends Void> write(ServerWebExchange exchange2, ServerResponse response) {
        exchange2.getResponse().getHeaders().setContentType(response.headers().getContentType());
        return response.writeTo(exchange2, (ServerResponse.Context)new ResponseContext());
    }

    private final class ResponseContext
    implements ServerResponse.Context {
        private ResponseContext() {
        }

        public List<HttpMessageWriter<?>> messageWriters() {
            return AbstractErrorWebExceptionHandler.this.messageWriters;
        }

        public List<ViewResolver> viewResolvers() {
            return AbstractErrorWebExceptionHandler.this.viewResolvers;
        }
    }
}

