/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import org.springframework.boot.actuate.health.CompositeHealthContributor;
import org.springframework.boot.actuate.health.CompositeHealthContributorReactiveAdapter;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicatorReactiveAdapter;
import org.springframework.util.Assert;

public interface ReactiveHealthContributor {
    public static ReactiveHealthContributor adapt(HealthContributor healthContributor) {
        Assert.notNull((Object)healthContributor, "'healthContributor' must not be null");
        if (healthContributor instanceof HealthIndicator) {
            HealthIndicator healthIndicator = (HealthIndicator)healthContributor;
            return new HealthIndicatorReactiveAdapter(healthIndicator);
        }
        if (healthContributor instanceof CompositeHealthContributor) {
            CompositeHealthContributor compositeHealthContributor = (CompositeHealthContributor)healthContributor;
            return new CompositeHealthContributorReactiveAdapter(compositeHealthContributor);
        }
        throw new IllegalStateException("Unknown HealthContributor type");
    }
}

