/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.springframework.boot.actuate.health.NamedContributor;
import org.springframework.boot.actuate.health.NamedContributors;
import org.springframework.util.Assert;

abstract class NamedContributorsMapAdapter<V, C>
implements NamedContributors<C> {
    private final Map<String, C> map;

    NamedContributorsMapAdapter(Map<String, V> map, Function<V, ? extends C> valueAdapter) {
        Assert.notNull(map, "'map' must not be null");
        Assert.notNull(valueAdapter, "'valueAdapter' must not be null");
        map.keySet().forEach(this::validateMapKey);
        this.map = Collections.unmodifiableMap(map.entrySet().stream().collect(LinkedHashMap::new, (result, entry) -> {
            String key = (String)entry.getKey();
            C value = this.adaptMapValue(entry.getValue(), valueAdapter);
            result.put(key, value);
        }, Map::putAll));
    }

    private void validateMapKey(String value) {
        Assert.notNull((Object)value, "'map' must not contain null keys");
        Assert.isTrue(!value.contains("/"), "'map' keys must not contain a '/'");
    }

    private C adaptMapValue(V value, Function<V, ? extends C> valueAdapter) {
        C contributor = value != null ? (C)valueAdapter.apply(value) : null;
        Assert.notNull(contributor, "'map' must not contain null values");
        return contributor;
    }

    @Override
    public Iterator<NamedContributor<C>> iterator() {
        final Iterator<Map.Entry<String, C>> iterator = this.map.entrySet().iterator();
        return new Iterator<NamedContributor<C>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public NamedContributor<C> next() {
                Map.Entry entry = (Map.Entry)iterator.next();
                return NamedContributor.of((String)entry.getKey(), entry.getValue());
            }
        };
    }

    @Override
    public C getContributor(String name) {
        return this.map.get(name);
    }
}

