/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.servlet;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.ModelAndView;

class CompositeHandlerAdapter
implements HandlerAdapter {
    private final ListableBeanFactory beanFactory;
    private List<HandlerAdapter> adapters;

    CompositeHandlerAdapter(ListableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public boolean supports(Object handler) {
        return this.getAdapter(handler).isPresent();
    }

    @Override
    public ModelAndView handle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        Optional<HandlerAdapter> adapter = this.getAdapter(handler);
        if (adapter.isPresent()) {
            return adapter.get().handle(request, response, handler);
        }
        return null;
    }

    @Override
    @Deprecated(since="2.4.9", forRemoval=false)
    public long getLastModified(HttpServletRequest request, Object handler) {
        Optional<HandlerAdapter> adapter = this.getAdapter(handler);
        return adapter.map(handlerAdapter -> handlerAdapter.getLastModified(request, handler)).orElse(0L);
    }

    private Optional<HandlerAdapter> getAdapter(Object handler) {
        if (this.adapters == null) {
            this.adapters = this.extractAdapters();
        }
        return this.adapters.stream().filter(a -> a.supports(handler)).findFirst();
    }

    private List<HandlerAdapter> extractAdapters() {
        ArrayList<HandlerAdapter> list = new ArrayList<HandlerAdapter>(this.beanFactory.getBeansOfType(HandlerAdapter.class).values());
        list.remove(this);
        AnnotationAwareOrderComparator.sort(list);
        return list;
    }
}

