/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.server;

import java.net.InetAddress;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.boot.web.server.Ssl;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="management.server")
public class ManagementServerProperties {
    private Integer port;
    private InetAddress address;
    private String basePath = "";
    @NestedConfigurationProperty
    private Ssl ssl;
    private final Jetty jetty = new Jetty();
    private final Tomcat tomcat = new Tomcat();
    private final Undertow undertow = new Undertow();

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = this.cleanBasePath(basePath);
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public void setSsl(Ssl ssl) {
        this.ssl = ssl;
    }

    public Jetty getJetty() {
        return this.jetty;
    }

    public Tomcat getTomcat() {
        return this.tomcat;
    }

    public Undertow getUndertow() {
        return this.undertow;
    }

    private String cleanBasePath(String basePath) {
        Object candidate = null;
        if (StringUtils.hasLength(basePath)) {
            candidate = basePath.strip();
        }
        if (StringUtils.hasText(candidate)) {
            if (!((String)candidate).startsWith("/")) {
                candidate = "/" + (String)candidate;
            }
            if (((String)candidate).endsWith("/")) {
                candidate = ((String)candidate).substring(0, ((String)candidate).length() - 1);
            }
        }
        return candidate;
    }

    public static class Jetty {
        private final Accesslog accesslog = new Accesslog();

        public Accesslog getAccesslog() {
            return this.accesslog;
        }
    }

    public static class Tomcat {
        private final Accesslog accesslog = new Accesslog();

        public Accesslog getAccesslog() {
            return this.accesslog;
        }
    }

    public static class Undertow {
        private final Accesslog accesslog = new Accesslog();

        public Accesslog getAccesslog() {
            return this.accesslog;
        }
    }

    public static class Accesslog {
        private String prefix = "management_";

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }
    }
}

