/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.reactive;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.apache.catalina.Valve;
import org.apache.catalina.valves.AccessLogValve;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.RequestLogWriter;
import org.eclipse.jetty.server.Server;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextConfiguration;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextType;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementWebServerFactoryCustomizer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.embedded.jetty.JettyReactiveWebServerFactory;
import org.springframework.boot.web.embedded.tomcat.TomcatReactiveWebServerFactory;
import org.springframework.boot.web.embedded.undertow.UndertowReactiveWebServerFactory;
import org.springframework.boot.web.server.ConfigurableWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.core.Ordered;
import org.springframework.http.server.reactive.ContextPathCompositeHandler;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.config.EnableWebFlux;
import org.springframework.web.server.adapter.WebHttpHandlerBuilder;

@EnableWebFlux
@ManagementContextConfiguration(value=ManagementContextType.CHILD, proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
public class ReactiveManagementChildContextConfiguration {
    @Bean
    public ManagementWebServerFactoryCustomizer<ConfigurableWebServerFactory> reactiveManagementWebServerFactoryCustomizer(ListableBeanFactory beanFactory) {
        return new ManagementWebServerFactoryCustomizer<ConfigurableWebServerFactory>(beanFactory);
    }

    @Bean
    public HttpHandler httpHandler(ApplicationContext applicationContext, ManagementServerProperties properties) {
        HttpHandler httpHandler = WebHttpHandlerBuilder.applicationContext(applicationContext).build();
        if (StringUtils.hasText(properties.getBasePath())) {
            Map<String, HttpHandler> handlersMap = Collections.singletonMap(properties.getBasePath(), httpHandler);
            return new ContextPathCompositeHandler(handlersMap);
        }
        return httpHandler;
    }

    @Bean
    @ConditionalOnClass(name={"io.undertow.Undertow"})
    UndertowAccessLogCustomizer undertowManagementAccessLogCustomizer(ManagementServerProperties properties) {
        return new UndertowAccessLogCustomizer(properties);
    }

    @Bean
    @ConditionalOnClass(name={"org.apache.catalina.valves.AccessLogValve"})
    TomcatAccessLogCustomizer tomcatManagementAccessLogCustomizer(ManagementServerProperties properties) {
        return new TomcatAccessLogCustomizer(properties);
    }

    @Bean
    @ConditionalOnClass(name={"org.eclipse.jetty.server.Server"})
    JettyAccessLogCustomizer jettyManagementAccessLogCustomizer(ManagementServerProperties properties) {
        return new JettyAccessLogCustomizer(properties);
    }

    static class UndertowAccessLogCustomizer
    extends AccessLogCustomizer
    implements WebServerFactoryCustomizer<UndertowReactiveWebServerFactory> {
        UndertowAccessLogCustomizer(ManagementServerProperties properties) {
            super(properties.getUndertow().getAccesslog().getPrefix());
        }

        @Override
        public void customize(UndertowReactiveWebServerFactory factory) {
            factory.setAccessLogPrefix(this.customizePrefix(factory.getAccessLogPrefix()));
        }
    }

    static class TomcatAccessLogCustomizer
    extends AccessLogCustomizer
    implements WebServerFactoryCustomizer<TomcatReactiveWebServerFactory> {
        TomcatAccessLogCustomizer(ManagementServerProperties properties) {
            super(properties.getTomcat().getAccesslog().getPrefix());
        }

        @Override
        public void customize(TomcatReactiveWebServerFactory factory) {
            AccessLogValve accessLogValve = this.findAccessLogValve(factory);
            if (accessLogValve == null) {
                return;
            }
            accessLogValve.setPrefix(this.customizePrefix(accessLogValve.getPrefix()));
        }

        private AccessLogValve findAccessLogValve(TomcatReactiveWebServerFactory factory) {
            for (Valve engineValve : factory.getEngineValves()) {
                if (!(engineValve instanceof AccessLogValve)) continue;
                AccessLogValve accessLogValve = (AccessLogValve)engineValve;
                return accessLogValve;
            }
            return null;
        }
    }

    static class JettyAccessLogCustomizer
    extends AccessLogCustomizer
    implements WebServerFactoryCustomizer<JettyReactiveWebServerFactory> {
        JettyAccessLogCustomizer(ManagementServerProperties properties) {
            super(properties.getJetty().getAccesslog().getPrefix());
        }

        @Override
        public void customize(JettyReactiveWebServerFactory factory) {
            factory.addServerCustomizers(this::customizeServer);
        }

        private void customizeServer(Server server) {
            RequestLog requestLog = server.getRequestLog();
            if (requestLog instanceof CustomRequestLog) {
                CustomRequestLog customRequestLog = (CustomRequestLog)requestLog;
                this.customizeRequestLog(customRequestLog);
            }
        }

        private void customizeRequestLog(CustomRequestLog requestLog) {
            RequestLog.Writer writer = requestLog.getWriter();
            if (writer instanceof RequestLogWriter) {
                RequestLogWriter requestLogWriter = (RequestLogWriter)writer;
                this.customizeRequestLogWriter(requestLogWriter);
            }
        }

        private void customizeRequestLogWriter(RequestLogWriter writer) {
            String filename = writer.getFileName();
            if (StringUtils.hasLength(filename)) {
                File file = new File(filename);
                file = new File(file.getParentFile(), this.customizePrefix(file.getName()));
                writer.setFilename(file.getPath());
            }
        }
    }

    static abstract class AccessLogCustomizer
    implements Ordered {
        private final String prefix;

        AccessLogCustomizer(String prefix) {
            this.prefix = prefix;
        }

        protected String customizePrefix(String existingPrefix) {
            if (this.prefix == null) {
                return existingPrefix;
            }
            if (existingPrefix == null) {
                return this.prefix;
            }
            if (existingPrefix.startsWith(this.prefix)) {
                return existingPrefix;
            }
            return this.prefix + existingPrefix;
        }

        @Override
        public int getOrder() {
            return 1;
        }
    }
}

