/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.tracing.zipkin;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.unit.DataSize;
import zipkin2.reporter.BaseHttpSender;
import zipkin2.reporter.Encoding;
import zipkin2.reporter.HttpEndpointSupplier;

abstract class HttpSender
extends BaseHttpSender<URI, byte[]> {
    private static final DataSize COMPRESSION_THRESHOLD = DataSize.ofKilobytes(1L);

    HttpSender(Encoding encoding, HttpEndpointSupplier.Factory endpointSupplierFactory, String endpoint) {
        super(encoding, endpointSupplierFactory, endpoint);
    }

    protected URI newEndpoint(String endpoint) {
        return URI.create(endpoint);
    }

    protected byte[] newBody(List<byte[]> list) {
        return this.encoding.encode(list);
    }

    protected void postSpans(URI endpoint, byte[] body2) throws IOException {
        MultiValueMap<String, String> headers = this.getDefaultHeaders();
        if (this.needsCompression(body2)) {
            body2 = this.compress(body2);
            headers.add("Content-Encoding", "gzip");
        }
        this.postSpans(endpoint, headers, body2);
    }

    abstract void postSpans(URI var1, MultiValueMap<String, String> var2, byte[] var3) throws IOException;

    MultiValueMap<String, String> getDefaultHeaders() {
        LinkedMultiValueMap<String, String> headers = new LinkedMultiValueMap<String, String>();
        headers.add("b3", "0");
        headers.add("Content-Type", this.encoding.mediaType());
        return headers;
    }

    private boolean needsCompression(byte[] body2) {
        return (long)body2.length > COMPRESSION_THRESHOLD.toBytes();
    }

    private byte[] compress(byte[] input) throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try (GZIPOutputStream gzip = new GZIPOutputStream(result);){
            gzip.write(input);
        }
        return result.toByteArray();
    }
}

