/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.session;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.session.ReactiveSessionsEndpoint;
import org.springframework.boot.actuate.session.SessionsEndpoint;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.session.SessionAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.ReactiveFindByIndexNameSessionRepository;
import org.springframework.session.ReactiveSessionRepository;
import org.springframework.session.Session;
import org.springframework.session.SessionRepository;

@AutoConfiguration(after={SessionAutoConfiguration.class})
@ConditionalOnClass(value={Session.class})
@ConditionalOnAvailableEndpoint(value=SessionsEndpoint.class)
public class SessionsEndpointAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    @ConditionalOnBean(value={ReactiveSessionRepository.class})
    static class ReactiveSessionEndpointConfiguration {
        ReactiveSessionEndpointConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        ReactiveSessionsEndpoint sessionsEndpoint(ReactiveSessionRepository<?> sessionRepository, ObjectProvider<ReactiveFindByIndexNameSessionRepository<?>> indexedSessionRepository) {
            return new ReactiveSessionsEndpoint(sessionRepository, indexedSessionRepository.getIfAvailable());
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @ConditionalOnBean(value={SessionRepository.class})
    static class ServletSessionEndpointConfiguration {
        ServletSessionEndpointConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        SessionsEndpoint sessionEndpoint(SessionRepository<?> sessionRepository, ObjectProvider<FindByIndexNameSessionRepository<?>> indexedSessionRepository) {
            return new SessionsEndpoint(sessionRepository, indexedSessionRepository.getIfAvailable());
        }
    }
}

