/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.export.otlp;

import io.micrometer.core.instrument.Clock;
import io.micrometer.registry.otlp.OtlpConfig;
import io.micrometer.registry.otlp.OtlpMeterRegistry;
import io.micrometer.registry.otlp.OtlpMetricsSender;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.ConditionalOnEnabledMetricsExport;
import org.springframework.boot.actuate.autoconfigure.metrics.export.otlp.OtlpMetricsConnectionDetails;
import org.springframework.boot.actuate.autoconfigure.metrics.export.otlp.OtlpMetricsProperties;
import org.springframework.boot.actuate.autoconfigure.metrics.export.otlp.OtlpMetricsPropertiesConfigAdapter;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.opentelemetry.OpenTelemetryProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnThreading;
import org.springframework.boot.autoconfigure.thread.Threading;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.core.task.VirtualThreadTaskExecutor;

@AutoConfiguration(before={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class}, after={MetricsAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@ConditionalOnClass(value={OtlpMeterRegistry.class})
@ConditionalOnEnabledMetricsExport(value="otlp")
@EnableConfigurationProperties(value={OtlpMetricsProperties.class, OpenTelemetryProperties.class})
public class OtlpMetricsExportAutoConfiguration {
    private final OtlpMetricsProperties properties;

    OtlpMetricsExportAutoConfiguration(OtlpMetricsProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    OtlpMetricsConnectionDetails otlpMetricsConnectionDetails() {
        return new PropertiesOtlpMetricsConnectionDetails(this.properties);
    }

    @Bean
    @ConditionalOnMissingBean
    OtlpConfig otlpConfig(OpenTelemetryProperties openTelemetryProperties, OtlpMetricsConnectionDetails connectionDetails, Environment environment2) {
        return new OtlpMetricsPropertiesConfigAdapter(this.properties, openTelemetryProperties, connectionDetails, environment2);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnThreading(value=Threading.PLATFORM)
    public OtlpMeterRegistry otlpMeterRegistry(OtlpConfig otlpConfig, Clock clock, ObjectProvider<OtlpMetricsSender> metricsSender) {
        return this.builder(otlpConfig, clock, metricsSender).build();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnThreading(value=Threading.VIRTUAL)
    public OtlpMeterRegistry otlpMeterRegistryVirtualThreads(OtlpConfig otlpConfig, Clock clock, ObjectProvider<OtlpMetricsSender> metricsSender) {
        VirtualThreadTaskExecutor executor = new VirtualThreadTaskExecutor("otlp-meter-registry-");
        return this.builder(otlpConfig, clock, metricsSender).threadFactory(executor.getVirtualThreadFactory()).build();
    }

    private OtlpMeterRegistry.Builder builder(OtlpConfig otlpConfig, Clock clock, ObjectProvider<OtlpMetricsSender> metricsSender) {
        OtlpMeterRegistry.Builder builder = OtlpMeterRegistry.builder((OtlpConfig)otlpConfig).clock(clock);
        metricsSender.ifAvailable(arg_0 -> ((OtlpMeterRegistry.Builder)builder).metricsSender(arg_0));
        return builder;
    }

    static class PropertiesOtlpMetricsConnectionDetails
    implements OtlpMetricsConnectionDetails {
        private final OtlpMetricsProperties properties;

        PropertiesOtlpMetricsConnectionDetails(OtlpMetricsProperties properties) {
            this.properties = properties;
        }

        @Override
        public String getUrl() {
            return this.properties.getUrl();
        }
    }
}

