/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.cache;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.SimpleAutowireCandidateResolver;
import org.springframework.boot.actuate.metrics.cache.CacheMeterBinderProvider;
import org.springframework.boot.actuate.metrics.cache.CacheMetricsRegistrar;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={CacheMeterBinderProvider.class, MeterRegistry.class})
class CacheMetricsRegistrarConfiguration {
    private static final String CACHE_MANAGER_SUFFIX = "cacheManager";
    private final MeterRegistry registry;
    private final CacheMetricsRegistrar cacheMetricsRegistrar;
    private final Map<String, CacheManager> cacheManagers;

    CacheMetricsRegistrarConfiguration(MeterRegistry registry, Collection<CacheMeterBinderProvider<?>> binderProviders, ConfigurableListableBeanFactory beanFactory) {
        this.registry = registry;
        this.cacheManagers = SimpleAutowireCandidateResolver.resolveAutowireCandidates(beanFactory, CacheManager.class);
        this.cacheMetricsRegistrar = new CacheMetricsRegistrar(this.registry, binderProviders);
        this.bindCachesToRegistry();
    }

    @Bean
    CacheMetricsRegistrar cacheMetricsRegistrar() {
        return this.cacheMetricsRegistrar;
    }

    private void bindCachesToRegistry() {
        this.cacheManagers.forEach(this::bindCacheManagerToRegistry);
    }

    private void bindCacheManagerToRegistry(String beanName, CacheManager cacheManager) {
        cacheManager.getCacheNames().forEach(cacheName -> this.bindCacheToRegistry(beanName, cacheManager.getCache((String)cacheName)));
    }

    private void bindCacheToRegistry(String beanName, Cache cache) {
        Tag cacheManagerTag = Tag.of("cache.manager", this.getCacheManagerName(beanName));
        this.cacheMetricsRegistrar.bindCacheToRegistry(cache, cacheManagerTag);
    }

    private String getCacheManagerName(String beanName) {
        if (beanName.length() > CACHE_MANAGER_SUFFIX.length() && StringUtils.endsWithIgnoreCase(beanName, CACHE_MANAGER_SUFFIX)) {
            return beanName.substring(0, beanName.length() - CACHE_MANAGER_SUFFIX.length());
        }
        return beanName;
    }
}

