/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.logging;

import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.logging.ConditionalOnEnabledLoggingExport;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.StringUtils;

class OnEnabledLoggingExportCondition
extends SpringBootCondition {
    private static final String GLOBAL_PROPERTY = "management.logging.export.enabled";
    private static final String EXPORTER_PROPERTY = "management.%s.logging.export.enabled";

    OnEnabledLoggingExportCondition() {
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Boolean globalLoggingEnabled;
        String loggingExporter = OnEnabledLoggingExportCondition.getExporterName(metadata);
        if (StringUtils.hasLength(loggingExporter)) {
            String formattedExporterProperty = EXPORTER_PROPERTY.formatted(loggingExporter);
            Boolean exporterLoggingEnabled = context.getEnvironment().getProperty(formattedExporterProperty, Boolean.class);
            if (exporterLoggingEnabled != null) {
                return new ConditionOutcome((boolean)exporterLoggingEnabled, ConditionMessage.forCondition(ConditionalOnEnabledLoggingExport.class, new Object[0]).because(formattedExporterProperty + " is " + exporterLoggingEnabled));
            }
        }
        if ((globalLoggingEnabled = context.getEnvironment().getProperty(GLOBAL_PROPERTY, Boolean.class)) != null) {
            return new ConditionOutcome((boolean)globalLoggingEnabled, ConditionMessage.forCondition(ConditionalOnEnabledLoggingExport.class, new Object[0]).because("management.logging.export.enabled is " + globalLoggingEnabled));
        }
        return ConditionOutcome.match(ConditionMessage.forCondition(ConditionalOnEnabledLoggingExport.class, new Object[0]).because("is enabled by default"));
    }

    private static String getExporterName(AnnotatedTypeMetadata metadata) {
        Map<String, Object> attributes = metadata.getAnnotationAttributes(ConditionalOnEnabledLoggingExport.class.getName());
        if (attributes == null) {
            return null;
        }
        return (String)attributes.get("value");
    }
}

