/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.availability;

import org.springframework.boot.actuate.autoconfigure.availability.AvailabilityHealthContributorAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.availability.AvailabilityProbesHealthEndpointGroupsPostProcessor;
import org.springframework.boot.actuate.availability.LivenessStateHealthIndicator;
import org.springframework.boot.actuate.availability.ReadinessStateHealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.availability.ApplicationAvailabilityAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.availability.ApplicationAvailability;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

@AutoConfiguration(after={AvailabilityHealthContributorAutoConfiguration.class, ApplicationAvailabilityAutoConfiguration.class})
@Conditional(value={ProbesCondition.class})
public class AvailabilityProbesAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(name={"livenessStateHealthIndicator"})
    public LivenessStateHealthIndicator livenessStateHealthIndicator(ApplicationAvailability applicationAvailability) {
        return new LivenessStateHealthIndicator(applicationAvailability);
    }

    @Bean
    @ConditionalOnMissingBean(name={"readinessStateHealthIndicator"})
    public ReadinessStateHealthIndicator readinessStateHealthIndicator(ApplicationAvailability applicationAvailability) {
        return new ReadinessStateHealthIndicator(applicationAvailability);
    }

    @Bean
    public AvailabilityProbesHealthEndpointGroupsPostProcessor availabilityProbesHealthEndpointGroupsPostProcessor(Environment environment2) {
        return new AvailabilityProbesHealthEndpointGroupsPostProcessor(environment2);
    }

    static class ProbesCondition
    extends SpringBootCondition {
        private static final String ENABLED_PROPERTY = "management.endpoint.health.probes.enabled";
        private static final String DEPRECATED_ENABLED_PROPERTY = "management.health.probes.enabled";

        ProbesCondition() {
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ConditionMessage.Builder message;
            Environment environment2 = context.getEnvironment();
            ConditionOutcome outcome = this.onProperty(environment2, message = ConditionMessage.forCondition("Probes availability", new Object[0]), ENABLED_PROPERTY);
            if (outcome != null) {
                return outcome;
            }
            outcome = this.onProperty(environment2, message, DEPRECATED_ENABLED_PROPERTY);
            if (outcome != null) {
                return outcome;
            }
            if (CloudPlatform.getActive(environment2) == CloudPlatform.KUBERNETES) {
                return ConditionOutcome.match(message.because("running on Kubernetes"));
            }
            if (CloudPlatform.getActive(environment2) == CloudPlatform.CLOUD_FOUNDRY) {
                return ConditionOutcome.match(message.because("running on Cloud Foundry"));
            }
            return ConditionOutcome.noMatch(message.because("not running on a supported cloud platform"));
        }

        private ConditionOutcome onProperty(Environment environment2, ConditionMessage.Builder message, String propertyName) {
            String enabled = environment2.getProperty(propertyName);
            if (enabled != null) {
                boolean match = !"false".equalsIgnoreCase(enabled);
                return new ConditionOutcome(match, message.because("'" + propertyName + "' set to '" + enabled + "'"));
            }
            return null;
        }
    }
}

