/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webmvc.ui;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.properties.SwaggerUiConfigParameters;
import org.springdoc.core.properties.SwaggerUiConfigProperties;
import org.springdoc.ui.AbstractSwaggerWelcome;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class SwaggerWelcomeCommon
extends AbstractSwaggerWelcome {
    protected SwaggerWelcomeCommon(SwaggerUiConfigProperties swaggerUiConfig, SpringDocConfigProperties springDocConfigProperties) {
        super(swaggerUiConfig, springDocConfigProperties);
    }

    protected ResponseEntity<Void> redirectToUi(HttpServletRequest request) {
        SwaggerUiConfigParameters swaggerUiConfigParameters = new SwaggerUiConfigParameters(this.swaggerUiConfig);
        this.buildFromCurrentContextPath(swaggerUiConfigParameters, request);
        String sbUrl = swaggerUiConfigParameters.getContextPath() + swaggerUiConfigParameters.getUiRootPath() + this.getSwaggerUiUrl();
        UriComponentsBuilder uriBuilder = this.getUriComponentsBuilder(swaggerUiConfigParameters, sbUrl);
        request.getParameterMap().forEach(uriBuilder::queryParam);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status(HttpStatus.FOUND).location(uriBuilder.build().encode().toUri())).build();
    }

    protected Map<String, Object> openapiJson(HttpServletRequest request) {
        SwaggerUiConfigParameters swaggerUiConfigParameters = new SwaggerUiConfigParameters(this.swaggerUiConfig);
        this.buildFromCurrentContextPath(swaggerUiConfigParameters, request);
        return swaggerUiConfigParameters.getConfigParameters();
    }

    @Override
    protected void calculateOauth2RedirectUrl(SwaggerUiConfigParameters swaggerUiConfigParameters, UriComponentsBuilder uriComponentsBuilder) {
        if (StringUtils.isBlank(this.swaggerUiConfig.getOauth2RedirectUrl()) || !swaggerUiConfigParameters.isValidUrl(this.swaggerUiConfig.getOauth2RedirectUrl())) {
            swaggerUiConfigParameters.setOauth2RedirectUrl(uriComponentsBuilder.path(swaggerUiConfigParameters.getUiRootPath()).path(this.getOauth2RedirectUrl()).build().toString());
        }
    }

    void buildFromCurrentContextPath(SwaggerUiConfigParameters swaggerUiConfigParameters, HttpServletRequest request) {
        super.init(swaggerUiConfigParameters);
        swaggerUiConfigParameters.setContextPath(request.getContextPath());
        this.buildConfigUrl(swaggerUiConfigParameters, ServletUriComponentsBuilder.fromCurrentContextPath());
    }
}

