/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webmvc.ui;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.springdoc.core.properties.SwaggerUiConfigParameters;
import org.springdoc.core.properties.SwaggerUiConfigProperties;
import org.springdoc.core.properties.SwaggerUiOAuthProperties;
import org.springdoc.core.providers.ObjectMapperProvider;
import org.springdoc.ui.AbstractSwaggerIndexTransformer;
import org.springdoc.webmvc.ui.SwaggerIndexTransformer;
import org.springdoc.webmvc.ui.SwaggerWelcomeCommon;
import org.springframework.core.io.Resource;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.servlet.resource.ResourceTransformerChain;
import org.springframework.web.servlet.resource.TransformedResource;

public class SwaggerIndexPageTransformer
extends AbstractSwaggerIndexTransformer
implements SwaggerIndexTransformer {
    private final SwaggerWelcomeCommon swaggerWelcomeCommon;

    public SwaggerIndexPageTransformer(SwaggerUiConfigProperties swaggerUiConfig, SwaggerUiOAuthProperties swaggerUiOAuthProperties, SwaggerWelcomeCommon swaggerWelcomeCommon, ObjectMapperProvider objectMapperProvider) {
        super(swaggerUiConfig, swaggerUiOAuthProperties, objectMapperProvider);
        this.swaggerWelcomeCommon = swaggerWelcomeCommon;
    }

    @Override
    public Resource transform(HttpServletRequest request, Resource resource, ResourceTransformerChain transformerChain) throws IOException {
        SwaggerUiConfigParameters swaggerUiConfigParameters = new SwaggerUiConfigParameters(this.swaggerUiConfig);
        this.swaggerWelcomeCommon.buildFromCurrentContextPath(swaggerUiConfigParameters, request);
        AntPathMatcher antPathMatcher = new AntPathMatcher();
        boolean isIndexFound = antPathMatcher.match("**/swagger-ui/**/swagger-initializer.js", resource.getURL().toString());
        if (isIndexFound) {
            String html = this.defaultTransformations(swaggerUiConfigParameters, resource.getInputStream());
            return new TransformedResource(resource, html.getBytes(StandardCharsets.UTF_8));
        }
        return resource;
    }
}

