/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webmvc.core.providers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.springdoc.core.fn.AbstractRouterFunctionVisitor;
import org.springdoc.core.providers.RouterFunctionProvider;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.function.HandlerFunction;
import org.springframework.web.servlet.function.RequestPredicate;
import org.springframework.web.servlet.function.RequestPredicates;
import org.springframework.web.servlet.function.RouterFunction;
import org.springframework.web.servlet.function.RouterFunctions;
import org.springframework.web.servlet.function.ServerRequest;

public class RouterFunctionWebMvcProvider
implements RouterFunctionProvider,
ApplicationContextAware {
    private ApplicationContext applicationContext;

    @Override
    public Optional<Map<String, AbstractRouterFunctionVisitor>> getRouterFunctionPaths() {
        Map<String, RouterFunction> routerBeans = this.applicationContext.getBeansOfType(RouterFunction.class);
        if (CollectionUtils.isEmpty(routerBeans)) {
            return Optional.empty();
        }
        HashMap<String, RouterFunctionVisitor> routerFunctionVisitorMap = new HashMap<String, RouterFunctionVisitor>();
        for (Map.Entry<String, RouterFunction> entry : routerBeans.entrySet()) {
            RouterFunction routerFunction = entry.getValue();
            RouterFunctionVisitor routerFunctionVisitor = new RouterFunctionVisitor();
            routerFunction.accept(routerFunctionVisitor);
            routerFunctionVisitorMap.put(entry.getKey(), routerFunctionVisitor);
        }
        return Optional.of(routerFunctionVisitorMap);
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private class RouterFunctionVisitor
    extends AbstractRouterFunctionVisitor
    implements RouterFunctions.Visitor,
    RequestPredicates.Visitor {
        private RouterFunctionVisitor() {
        }

        @Override
        public void route(RequestPredicate predicate, HandlerFunction<?> handlerFunction) {
            this.currentRouterFunctionDatas = new ArrayList();
            predicate.accept(this);
            this.commonRoute();
        }

        @Override
        public void resources(Function<ServerRequest, Optional<Resource>> lookupFunction) {
        }

        @Override
        public void unknown(RouterFunction<?> routerFunction) {
        }

        @Override
        public void unknown(RequestPredicate predicate) {
        }

        @Override
        public void startNested(RequestPredicate predicate) {
            this.commonStartNested();
            predicate.accept(this);
        }

        @Override
        public void endNested(RequestPredicate predicate) {
            this.commonEndNested();
        }
    }
}

