/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webmvc.core.providers;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.providers.ActuatorProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.actuate.endpoint.web.servlet.ControllerEndpointHandlerMapping;
import org.springframework.boot.actuate.endpoint.web.servlet.WebMvcEndpointHandlerMapping;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

public class ActuatorWebMvcProvider
extends ActuatorProvider {
    public ActuatorWebMvcProvider(ServerProperties serverProperties, SpringDocConfigProperties springDocConfigProperties, Optional<ManagementServerProperties> managementServerProperties, Optional<WebEndpointProperties> webEndpointProperties) {
        super(managementServerProperties, webEndpointProperties, serverProperties, springDocConfigProperties);
    }

    @Override
    public Map<RequestMappingInfo, HandlerMethod> getMethods() {
        HashMap<RequestMappingInfo, HandlerMethod> mappingInfoHandlerMethodMap = new HashMap<RequestMappingInfo, HandlerMethod>();
        WebMvcEndpointHandlerMapping webMvcEndpointHandlerMapping = this.applicationContext.getBeansOfType(WebMvcEndpointHandlerMapping.class).values().stream().findFirst().orElse(null);
        if (webMvcEndpointHandlerMapping == null) {
            webMvcEndpointHandlerMapping = this.managementApplicationContext.getBean(WebMvcEndpointHandlerMapping.class);
        }
        mappingInfoHandlerMethodMap.putAll(webMvcEndpointHandlerMapping.getHandlerMethods());
        ControllerEndpointHandlerMapping controllerEndpointHandlerMapping = this.applicationContext.getBeansOfType(ControllerEndpointHandlerMapping.class).values().stream().findFirst().orElse(null);
        if (controllerEndpointHandlerMapping == null) {
            controllerEndpointHandlerMapping = this.managementApplicationContext.getBean(ControllerEndpointHandlerMapping.class);
        }
        mappingInfoHandlerMethodMap.putAll(controllerEndpointHandlerMapping.getHandlerMethods());
        return mappingInfoHandlerMethodMap;
    }

    @Override
    public String getContextPath() {
        return StringUtils.defaultIfEmpty(this.serverProperties.getServlet().getContextPath(), "");
    }
}

