/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.utils;

import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.util.PrimitiveType;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springdoc.api.AbstractOpenApiResource;
import org.springdoc.core.converters.AdditionalModelsConverter;
import org.springdoc.core.converters.ConverterUtils;
import org.springdoc.core.converters.PolymorphicModelConverter;
import org.springdoc.core.converters.SchemaPropertyDeprecatingConverter;
import org.springdoc.core.extractor.MethodParameterPojoExtractor;
import org.springdoc.core.service.AbstractRequestService;
import org.springdoc.core.service.GenericParameterService;
import org.springdoc.core.service.GenericResponseService;
import org.springdoc.core.utils.SpringDocAnnotationsUtils;
import org.springframework.core.MethodParameter;
import org.springframework.util.CollectionUtils;

public class SpringDocUtils {
    private static final SpringDocUtils springDocConfig = new SpringDocUtils();

    private SpringDocUtils() {
    }

    public static SpringDocUtils getConfig() {
        return springDocConfig;
    }

    public SpringDocUtils addDeprecatedType(Class<? extends Annotation> cls) {
        SchemaPropertyDeprecatingConverter.addDeprecatedType(cls);
        return this;
    }

    public SpringDocUtils addRestControllers(Class<?> ... classes) {
        AbstractOpenApiResource.addRestControllers(classes);
        return this;
    }

    public SpringDocUtils addHiddenRestControllers(Class<?> ... classes) {
        AbstractOpenApiResource.addHiddenRestControllers(classes);
        return this;
    }

    public SpringDocUtils addHiddenRestControllers(String ... classes) {
        AbstractOpenApiResource.addHiddenRestControllers(classes);
        return this;
    }

    public SpringDocUtils replaceWithClass(Class source, Class target) {
        AdditionalModelsConverter.replaceWithClass(source, target);
        return this;
    }

    public SpringDocUtils replaceWithSchema(Class source, Schema target) {
        AdditionalModelsConverter.replaceWithSchema(source, target);
        return this;
    }

    public SpringDocUtils addRequestWrapperToIgnore(Class<?> ... classes) {
        AbstractRequestService.addRequestWrapperToIgnore(classes);
        return this;
    }

    public SpringDocUtils removeRequestWrapperToIgnore(Class<?> ... classes) {
        AbstractRequestService.removeRequestWrapperToIgnore(classes);
        return this;
    }

    public SpringDocUtils addFileType(Class<?> ... classes) {
        GenericParameterService.addFileType(classes);
        return this;
    }

    public SpringDocUtils addResponseWrapperToIgnore(Class<?> cls) {
        ConverterUtils.addResponseWrapperToIgnore(cls);
        return this;
    }

    public SpringDocUtils removeResponseWrapperToIgnore(Class<?> cls) {
        ConverterUtils.removeResponseWrapperToIgnore(cls);
        return this;
    }

    public SpringDocUtils addResponseTypeToIgnore(Class<?> cls) {
        ConverterUtils.addResponseTypeToIgnore(cls);
        return this;
    }

    public SpringDocUtils removeResponseTypeToIgnore(Class<?> cls) {
        ConverterUtils.removeResponseTypeToIgnore(cls);
        return this;
    }

    public SpringDocUtils addAnnotationsToIgnore(Class<?> ... classes) {
        SpringDocAnnotationsUtils.addAnnotationsToIgnore(classes);
        return this;
    }

    public SpringDocUtils removeAnnotationsToIgnore(Class<?> ... classes) {
        SpringDocAnnotationsUtils.removeAnnotationsToIgnore(classes);
        return this;
    }

    public SpringDocUtils addFluxWrapperToIgnore(Class<?> cls) {
        ConverterUtils.addFluxWrapperToIgnore(cls);
        return this;
    }

    public SpringDocUtils removeFluxWrapperToIgnore(Class<?> cls) {
        ConverterUtils.removeFluxWrapperToIgnore(cls);
        return this;
    }

    public SpringDocUtils addSimpleTypesForParameterObject(Class<?> ... classes) {
        MethodParameterPojoExtractor.addSimpleTypes(classes);
        return this;
    }

    public SpringDocUtils removeSimpleTypesForParameterObject(Class<?> ... classes) {
        MethodParameterPojoExtractor.removeSimpleTypes(classes);
        return this;
    }

    public SpringDocUtils addSimpleTypePredicateForParameterObject(Predicate<Class<?>> predicate) {
        MethodParameterPojoExtractor.addSimpleTypePredicate(predicate);
        return this;
    }

    public SpringDocUtils disableReplacement(Class source) {
        AdditionalModelsConverter.disableReplacement(source);
        return this;
    }

    public SpringDocUtils replaceParameterObjectWithClass(Class source, Class target) {
        AdditionalModelsConverter.replaceParameterObjectWithClass(source, target);
        return this;
    }

    public SpringDocUtils setResponseEntityExceptionHandlerClass(Class<?> clazz) {
        GenericResponseService.setResponseEntityExceptionHandlerClass(clazz);
        return this;
    }

    public SpringDocUtils setModelAndViewClass(Class<?> clazz) {
        AbstractOpenApiResource.setModelAndViewClass(clazz);
        return this;
    }

    public SpringDocUtils removeFromSchemaMap(Class<?> clazz) {
        AdditionalModelsConverter.removeFromSchemaMap(clazz);
        return this;
    }

    public SpringDocUtils removeFromSchemaMap(Class<?> ... classes) {
        for (Class<?> aClass : classes) {
            AdditionalModelsConverter.removeFromSchemaMap(aClass);
        }
        return this;
    }

    public SpringDocUtils removeFromSchemaClass(Class<?> clazz) {
        AdditionalModelsConverter.removeFromClassMap(clazz);
        return this;
    }

    public SpringDocUtils addJavaTypeToIgnore(Class<?> clazz) {
        ConverterUtils.addJavaTypeToIgnore(clazz);
        return this;
    }

    public SpringDocUtils removeJavaTypeToIgnore(Class<?> clazz) {
        ConverterUtils.removeJavaTypeToIgnore(clazz);
        return this;
    }

    public static boolean isValidPath(String path) {
        return StringUtils.isNotBlank(path) && !path.equals("/");
    }

    public SpringDocUtils addParentType(String ... parentTypes) {
        PolymorphicModelConverter.addParentType(parentTypes);
        return this;
    }

    @NotNull
    public static Annotation[] getParameterAnnotations(MethodParameter methodParameter) {
        Object[] annotations = methodParameter.getParameterAnnotations();
        if (ArrayUtils.isEmpty(annotations)) {
            return new Annotation[0];
        }
        ArrayList<Object> resultAnnotations = new ArrayList<Object>(annotations.length);
        resultAnnotations.addAll(List.of(annotations));
        for (Object annotation : annotations) {
            Annotation[] metaAnnotations = annotation.annotationType().getAnnotations();
            if (!ArrayUtils.isNotEmpty(metaAnnotations)) continue;
            resultAnnotations.addAll(List.of(metaAnnotations));
        }
        return resultAnnotations.toArray(new Annotation[0]);
    }

    @NotNull
    public static String getParentTypeName(AnnotatedType type, Class<?> cls) {
        return cls.getSimpleName() + StringUtils.capitalize(type.getParent().getType() != null ? type.getParent().getType() : "object");
    }

    public static boolean isComposedSchema(Schema referencedSchema) {
        return referencedSchema.getOneOf() != null || referencedSchema.getAllOf() != null || referencedSchema.getAnyOf() != null || referencedSchema instanceof ComposedSchema;
    }

    public static void handleSchemaTypes(Schema<?> schema) {
        if (schema != null) {
            if (schema.getType() != null && CollectionUtils.isEmpty(schema.getTypes())) {
                schema.addType(schema.getType());
            } else if (schema.getItems() != null && schema.getItems().getType() != null && CollectionUtils.isEmpty(schema.getItems().getTypes())) {
                schema.getItems().addType(schema.getItems().getType());
            }
            if (schema.getProperties() != null) {
                schema.getProperties().forEach((key, value) -> SpringDocUtils.handleSchemaTypes(value));
            }
            if (schema.getType() == null && schema.getTypes() == null && schema.get$ref() == null && !SpringDocUtils.isComposedSchema(schema)) {
                schema.addType("object");
            }
        }
    }

    public static void handleSchemaTypes(Content content) {
        if (content != null) {
            content.values().forEach(mediaType -> {
                if (mediaType.getSchema() != null) {
                    SpringDocUtils.handleSchemaTypes(mediaType.getSchema());
                }
            });
        }
    }

    public SpringDocUtils initExtraSchemas() {
        PrimitiveType.customClasses().put("java.time.Duration", PrimitiveType.STRING);
        PrimitiveType.customClasses().put("java.time.LocalTime", PrimitiveType.STRING);
        PrimitiveType.customClasses().put("java.time.YearMonth", PrimitiveType.STRING);
        PrimitiveType.customClasses().put("java.time.MonthDay", PrimitiveType.STRING);
        PrimitiveType.customClasses().put("java.time.Year", PrimitiveType.STRING);
        PrimitiveType.customClasses().put("java.time.Period", PrimitiveType.STRING);
        PrimitiveType.customClasses().put("java.time.OffsetTime", PrimitiveType.STRING);
        PrimitiveType.customClasses().put("java.time.ZoneId", PrimitiveType.STRING);
        PrimitiveType.customClasses().put("java.time.ZoneOffset", PrimitiveType.STRING);
        PrimitiveType.customClasses().put("java.util.TimeZone", PrimitiveType.STRING);
        PrimitiveType.customClasses().put("java.util.Charset", PrimitiveType.STRING);
        PrimitiveType.customClasses().put("java.util.Locale", PrimitiveType.STRING);
        return this;
    }

    public SpringDocUtils resetExtraSchemas() {
        PrimitiveType.customClasses().remove("java.time.Duration");
        PrimitiveType.customClasses().remove("java.time.LocalTime");
        PrimitiveType.customClasses().remove("java.time.YearMonth");
        PrimitiveType.customClasses().remove("java.time.MonthDay");
        PrimitiveType.customClasses().remove("java.time.Year");
        PrimitiveType.customClasses().remove("java.time.Period");
        PrimitiveType.customClasses().remove("java.time.OffsetTime");
        PrimitiveType.customClasses().remove("java.time.ZoneId");
        PrimitiveType.customClasses().remove("java.time.ZoneOffset");
        PrimitiveType.customClasses().remove("java.util.TimeZone");
        PrimitiveType.customClasses().remove("java.util.Charset");
        PrimitiveType.customClasses().remove("java.util.Locale");
        return this;
    }
}

