/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.service;

import com.hazelcast.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.core.jackson.TypeNameResolver;
import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Webhook;
import io.swagger.v3.oas.annotations.Webhooks;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import io.swagger.v3.oas.annotations.security.SecuritySchemes;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.servers.Server;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.customizers.OpenApiBuilderCustomizer;
import org.springdoc.core.customizers.ServerBaseUrlCustomizer;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.providers.JavadocProvider;
import org.springdoc.core.service.SecuritySchemePair;
import org.springdoc.core.service.SecurityService;
import org.springdoc.core.utils.PropertyResolverUtils;
import org.springdoc.core.utils.SpringDocUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.http.HttpRequest;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.HandlerMethod;

public class OpenAPIService
implements ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenAPIService.class);
    private static Class<?> basicErrorController;
    private final SecurityService securityParser;
    private final Map<String, Object> mappingsMap = new HashMap<String, Object>();
    private final Map<HandlerMethod, io.swagger.v3.oas.models.tags.Tag> springdocTags = new HashMap<HandlerMethod, io.swagger.v3.oas.models.tags.Tag>();
    private final Optional<List<OpenApiBuilderCustomizer>> openApiBuilderCustomisers;
    private final Optional<List<ServerBaseUrlCustomizer>> serverBaseUrlCustomizers;
    private final SpringDocConfigProperties springDocConfigProperties;
    private final Map<String, OpenAPI> cachedOpenAPI = new HashMap<String, OpenAPI>();
    private final PropertyResolverUtils propertyResolverUtils;
    private final Optional<JavadocProvider> javadocProvider;
    private ApplicationContext context;
    private OpenAPI openAPI;
    private boolean isServersPresent;

    public OpenAPIService(Optional<OpenAPI> openAPI, SecurityService securityParser, SpringDocConfigProperties springDocConfigProperties, PropertyResolverUtils propertyResolverUtils, Optional<List<OpenApiBuilderCustomizer>> openApiBuilderCustomizers, Optional<List<ServerBaseUrlCustomizer>> serverBaseUrlCustomizers, Optional<JavadocProvider> javadocProvider) {
        if (openAPI.isPresent()) {
            this.openAPI = openAPI.get();
            if (this.openAPI.getComponents() == null) {
                this.openAPI.setComponents(new Components());
            }
            if (this.openAPI.getPaths() == null) {
                this.openAPI.setPaths(new Paths());
            }
            if (!CollectionUtils.isEmpty(this.openAPI.getServers())) {
                this.isServersPresent = true;
            }
        }
        this.propertyResolverUtils = propertyResolverUtils;
        this.securityParser = securityParser;
        this.springDocConfigProperties = springDocConfigProperties;
        this.openApiBuilderCustomisers = openApiBuilderCustomizers;
        this.serverBaseUrlCustomizers = serverBaseUrlCustomizers;
        this.javadocProvider = javadocProvider;
        if (springDocConfigProperties.isUseFqn()) {
            TypeNameResolver.std.setUseFqn(true);
        }
    }

    public static String splitCamelCase(String str) {
        return str.replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), "-").toLowerCase(Locale.ROOT);
    }

    public OpenAPI build(Locale locale) {
        Optional<OpenAPIDefinition> apiDef = this.getOpenAPIDefinition();
        OpenAPI calculatedOpenAPI = null;
        if (this.openAPI == null) {
            calculatedOpenAPI = new OpenAPI(this.springDocConfigProperties.getSpecVersion());
            calculatedOpenAPI.setComponents(new Components());
            calculatedOpenAPI.setPaths(new Paths());
        } else {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                calculatedOpenAPI = objectMapper.readValue(objectMapper.writeValueAsString(this.openAPI), OpenAPI.class);
            }
            catch (JsonProcessingException e) {
                LOGGER.warn("Json Processing Exception occurred: {}", (Object)e.getMessage());
                calculatedOpenAPI = this.openAPI;
            }
        }
        if (apiDef.isPresent()) {
            this.buildOpenAPIWithOpenAPIDefinition(calculatedOpenAPI, apiDef.get(), locale);
        } else if (calculatedOpenAPI != null && calculatedOpenAPI.getInfo() == null) {
            Info infos = new Info().title("OpenAPI definition").version("v0");
            calculatedOpenAPI.setInfo(infos);
        }
        this.mappingsMap.putAll(this.context.getBeansWithAnnotation(RestController.class));
        this.mappingsMap.putAll(this.context.getBeansWithAnnotation(RequestMapping.class));
        this.mappingsMap.putAll(this.context.getBeansWithAnnotation(Controller.class));
        this.initializeHiddenRestController();
        if (calculatedOpenAPI != null) {
            this.calculateSecuritySchemes(calculatedOpenAPI.getComponents(), locale);
        }
        this.openApiBuilderCustomisers.ifPresent(customizers -> customizers.forEach(customiser -> customiser.customise(this)));
        return calculatedOpenAPI;
    }

    private void initializeHiddenRestController() {
        List<Class> hiddenRestControllers;
        if (basicErrorController != null) {
            SpringDocUtils.getConfig().addHiddenRestControllers(basicErrorController);
        }
        if (!CollectionUtils.isEmpty(hiddenRestControllers = this.mappingsMap.entrySet().parallelStream().filter(controller -> AnnotationUtils.findAnnotation(controller.getValue().getClass(), Hidden.class) != null).map(controller -> controller.getValue().getClass()).collect(Collectors.toList()))) {
            SpringDocUtils.getConfig().addHiddenRestControllers(hiddenRestControllers.toArray(new Class[hiddenRestControllers.size()]));
        }
    }

    public void updateServers(String serverBaseUrl, OpenAPI openAPI) {
        if (!this.isServersPresent && serverBaseUrl != null) {
            Server server = new Server().url(serverBaseUrl).description("Generated server url");
            ArrayList<Server> servers = new ArrayList<Server>();
            servers.add(server);
            openAPI.setServers(servers);
        }
    }

    public void setServersPresent(boolean serversPresent) {
        this.isServersPresent = serversPresent;
    }

    public Operation buildTags(HandlerMethod handlerMethod, Operation operation, OpenAPI openAPI, Locale locale) {
        SecurityRequirement[] securityRequirements;
        HashSet<io.swagger.v3.oas.models.tags.Tag> tags = new HashSet<io.swagger.v3.oas.models.tags.Tag>();
        Set<String> tagsStr = new HashSet<String>();
        this.buildTagsFromMethod(handlerMethod.getMethod(), tags, tagsStr, locale);
        this.buildTagsFromClass(handlerMethod.getBeanType(), tags, tagsStr, locale);
        if (!CollectionUtils.isEmpty(tagsStr)) {
            tagsStr = tagsStr.stream().map(str -> this.propertyResolverUtils.resolve((String)str, locale)).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        if (this.springdocTags.containsKey(handlerMethod)) {
            io.swagger.v3.oas.models.tags.Tag tag = this.springdocTags.get(handlerMethod);
            tagsStr.add(tag.getName());
            if (openAPI.getTags() == null || !openAPI.getTags().contains(tag)) {
                openAPI.addTagsItem(tag);
            }
        }
        if (!CollectionUtils.isEmpty(tagsStr)) {
            if (CollectionUtils.isEmpty(operation.getTags())) {
                operation.setTags(new ArrayList<String>(tagsStr));
            } else {
                HashSet<String> operationTagsSet = new HashSet<String>(operation.getTags());
                operationTagsSet.addAll(tagsStr);
                operation.getTags().clear();
                operation.getTags().addAll(operationTagsSet);
            }
        }
        if (this.isAutoTagClasses(operation)) {
            String description;
            String tagAutoName = OpenAPIService.splitCamelCase(handlerMethod.getBeanType().getSimpleName());
            operation.addTagsItem(tagAutoName);
            if (this.javadocProvider.isPresent() && StringUtils.isNotBlank(description = this.javadocProvider.get().getClassJavadoc(handlerMethod.getBeanType()))) {
                io.swagger.v3.oas.models.tags.Tag tag = new io.swagger.v3.oas.models.tags.Tag();
                tag.setName(tagAutoName);
                tag.setDescription(description);
                if (openAPI.getTags() == null || !openAPI.getTags().contains(tag)) {
                    openAPI.addTagsItem(tag);
                }
            }
        }
        if (!CollectionUtils.isEmpty(tags)) {
            List<io.swagger.v3.oas.models.tags.Tag> openApiTags = openAPI.getTags();
            if (!CollectionUtils.isEmpty(openApiTags)) {
                tags.addAll(openApiTags);
            }
            openAPI.setTags(new ArrayList<io.swagger.v3.oas.models.tags.Tag>(tags));
        }
        if ((securityRequirements = this.securityParser.getSecurityRequirements(handlerMethod)) != null) {
            if (securityRequirements.length == 0) {
                operation.setSecurity(Collections.emptyList());
            } else {
                this.securityParser.buildSecurityRequirement(securityRequirements, operation);
            }
        }
        return operation;
    }

    private void buildTagsFromMethod(Method method, Set<io.swagger.v3.oas.models.tags.Tag> tags, Set<String> tagsStr, Locale locale) {
        Set<Tags> tagsSet = AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)method, Tags.class);
        Set methodTags = tagsSet.stream().flatMap(x -> Stream.of(x.value())).collect(Collectors.toCollection(LinkedHashSet::new));
        methodTags.addAll(AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)method, Tag.class));
        if (!CollectionUtils.isEmpty(methodTags)) {
            tagsStr.addAll(methodTags.stream().map(tag -> this.propertyResolverUtils.resolve(tag.name(), locale)).collect(Collectors.toCollection(LinkedHashSet::new)));
            ArrayList<Tag> allTags = new ArrayList<Tag>(methodTags);
            this.addTags(allTags, tags, locale);
        }
    }

    private void addTags(List<Tag> sourceTags, Set<io.swagger.v3.oas.models.tags.Tag> tags, Locale locale) {
        Optional<Set<io.swagger.v3.oas.models.tags.Tag>> optionalTagSet = AnnotationsUtils.getTags(sourceTags.toArray(new Tag[0]), true);
        optionalTagSet.ifPresent(tagsSet -> tagsSet.forEach(tag -> {
            tag.name(this.propertyResolverUtils.resolve(tag.getName(), locale));
            tag.description(this.propertyResolverUtils.resolve(tag.getDescription(), locale));
            if (tags.stream().noneMatch(t -> t.getName().equals(tag.getName()))) {
                tags.add((io.swagger.v3.oas.models.tags.Tag)tag);
            }
        }));
    }

    public void buildTagsFromClass(Class<?> beanType, Set<io.swagger.v3.oas.models.tags.Tag> tags, Set<String> tagsStr, Locale locale) {
        ArrayList<Tag> allTags = new ArrayList<Tag>();
        Set<Tags> tagsSet = AnnotatedElementUtils.findAllMergedAnnotations(beanType, Tags.class);
        Set classTags = tagsSet.stream().flatMap(x -> Stream.of(x.value())).collect(Collectors.toCollection(LinkedHashSet::new));
        classTags.addAll(AnnotatedElementUtils.findAllMergedAnnotations(beanType, Tag.class));
        if (!CollectionUtils.isEmpty(classTags)) {
            tagsStr.addAll(classTags.stream().map(tag -> this.propertyResolverUtils.resolve(tag.name(), locale)).collect(Collectors.toCollection(LinkedHashSet::new)));
            allTags.addAll(classTags);
            this.addTags(allTags, tags, locale);
        }
    }

    public Schema resolveProperties(Schema schema, Locale locale) {
        this.resolveProperty(schema::getName, schema::name, this.propertyResolverUtils, locale);
        this.resolveProperty(schema::getTitle, schema::title, this.propertyResolverUtils, locale);
        this.resolveProperty(schema::getDescription, schema::description, this.propertyResolverUtils, locale);
        Map<String, Schema> properties = schema.getProperties();
        if (!CollectionUtils.isEmpty(properties)) {
            LinkedHashMap resolvedSchemas = properties.entrySet().stream().map(es -> {
                es.setValue(this.resolveProperties((Schema)es.getValue(), locale));
                if (((Schema)es.getValue()).getItems() != null) {
                    this.resolveProperties(((Schema)es.getValue()).getItems(), locale);
                }
                return es;
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e2, LinkedHashMap::new));
            schema.setProperties(resolvedSchemas);
        }
        return schema;
    }

    public String calculateServerBaseUrl(String serverBaseUrl, HttpRequest httpRequest) {
        String customServerBaseUrl = serverBaseUrl;
        if (this.serverBaseUrlCustomizers.isPresent()) {
            for (ServerBaseUrlCustomizer customizer2 : this.serverBaseUrlCustomizers.get()) {
                customServerBaseUrl = customizer2.customize(customServerBaseUrl, httpRequest);
            }
        }
        return customServerBaseUrl;
    }

    private Optional<OpenAPIDefinition> getOpenAPIDefinition() {
        Map<String, Object> openAPIDefinitionMap = this.context.getBeansWithAnnotation(OpenAPIDefinition.class);
        OpenAPIDefinition apiDef = null;
        if (openAPIDefinitionMap.size() > 1) {
            LOGGER.warn("found more than one OpenAPIDefinition class. springdoc-openapi will be using the first one found.");
        }
        if (openAPIDefinitionMap.size() > 0) {
            Map.Entry<String, Object> entry = openAPIDefinitionMap.entrySet().iterator().next();
            Class<?> objClz = entry.getValue().getClass();
            apiDef = AnnotatedElementUtils.findMergedAnnotation(objClz, OpenAPIDefinition.class);
        } else {
            ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
            scanner.addIncludeFilter(new AnnotationTypeFilter(OpenAPIDefinition.class));
            if (AutoConfigurationPackages.has(this.context)) {
                List<String> packagesToScan = AutoConfigurationPackages.get(this.context);
                apiDef = this.getApiDefClass(scanner, packagesToScan);
            }
        }
        return Optional.ofNullable(apiDef);
    }

    public Webhooks[] getWebhooks() {
        ArrayList<Webhooks> allWebhooks = new ArrayList<Webhooks>();
        Map<String, Object> beans2 = this.context.getBeansWithAnnotation(Webhooks.class);
        for (Object bean2 : beans2.values()) {
            Class<?> beanClass = bean2.getClass();
            this.collectWebhooksFromElement(beanClass, allWebhooks);
            for (Method method : beanClass.getDeclaredMethods()) {
                this.collectWebhooksFromElement(method, allWebhooks);
            }
        }
        if (allWebhooks.isEmpty()) {
            ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
            scanner.addIncludeFilter(new AnnotationTypeFilter(Webhooks.class));
            scanner.addIncludeFilter(new AnnotationTypeFilter(Webhook.class));
            if (AutoConfigurationPackages.has(this.context)) {
                for (String basePackage : AutoConfigurationPackages.get(this.context)) {
                    Set<BeanDefinition> candidates = scanner.findCandidateComponents(basePackage);
                    for (BeanDefinition bd : candidates) {
                        try {
                            Class<?> clazz = Class.forName(bd.getBeanClassName());
                            this.collectWebhooksFromElement(clazz, allWebhooks);
                            for (Method method : clazz.getDeclaredMethods()) {
                                this.collectWebhooksFromElement(method, allWebhooks);
                            }
                        }
                        catch (ClassNotFoundException e) {
                            LOGGER.error("Class not found in classpath: {}", (Object)e.getMessage());
                        }
                    }
                }
            }
        }
        return allWebhooks.toArray(new Webhooks[0]);
    }

    private void collectWebhooksFromElement(AnnotatedElement element, List<Webhooks> collector) {
        Webhook[] individualWebhooks;
        Webhooks container = element.getAnnotation(Webhooks.class);
        if (container != null) {
            collector.add(container);
        }
        if ((individualWebhooks = (Webhook[])element.getAnnotationsByType(Webhook.class)).length > 0) {
            collector.add(new Webhooks(){

                @Override
                public Webhook[] value() {
                    return individualWebhooks;
                }

                @Override
                public Class<? extends Annotation> annotationType() {
                    return Webhooks.class;
                }
            });
        }
    }

    private void buildOpenAPIWithOpenAPIDefinition(OpenAPI openAPI, OpenAPIDefinition apiDef, Locale locale) {
        boolean isOpenapi3 = this.propertyResolverUtils.isOpenapi31();
        Map<String, Object> extensions = AnnotationsUtils.getExtensions(isOpenapi3, apiDef.info().extensions());
        AnnotationsUtils.getInfo(apiDef.info(), true).map(info -> this.resolveProperties((Info)info, extensions, locale)).ifPresent(openAPI::setInfo);
        this.securityParser.getSecurityRequirements(apiDef.security()).ifPresent(openAPI::setSecurity);
        AnnotationsUtils.getExternalDocumentation(apiDef.externalDocs(), isOpenapi3).ifPresent(openAPI::setExternalDocs);
        AnnotationsUtils.getTags(apiDef.tags(), false).ifPresent(tags -> openAPI.setTags(new ArrayList<io.swagger.v3.oas.models.tags.Tag>((Collection<io.swagger.v3.oas.models.tags.Tag>)tags)));
        Optional<List<Server>> optionalServers = AnnotationsUtils.getServers(apiDef.servers());
        optionalServers.map(servers -> this.resolveProperties((List<Server>)servers, locale)).ifPresent(servers -> {
            this.isServersPresent = true;
            openAPI.servers((List<Server>)servers);
        });
        if (apiDef.extensions().length > 0) {
            openAPI.setExtensions(AnnotationsUtils.getExtensions(isOpenapi3, apiDef.extensions()));
        }
    }

    private List<Server> resolveProperties(List<Server> servers, Locale locale) {
        servers.forEach(server -> {
            this.resolveProperty(server::getUrl, server::url, this.propertyResolverUtils, locale);
            this.resolveProperty(server::getDescription, server::description, this.propertyResolverUtils, locale);
            if (CollectionUtils.isEmpty(server.getVariables())) {
                server.setVariables(null);
            }
        });
        return servers;
    }

    private Info resolveProperties(Info info, Map<String, Object> extensions, Locale locale) {
        Contact contact;
        this.resolveProperty(info::getTitle, info::title, this.propertyResolverUtils, locale);
        this.resolveProperty(info::getDescription, info::description, this.propertyResolverUtils, locale);
        this.resolveProperty(info::getVersion, info::version, this.propertyResolverUtils, locale);
        this.resolveProperty(info::getTermsOfService, info::termsOfService, this.propertyResolverUtils, locale);
        License license = info.getLicense();
        if (license != null) {
            this.resolveProperty(license::getName, license::name, this.propertyResolverUtils, locale);
            this.resolveProperty(license::getUrl, license::url, this.propertyResolverUtils, locale);
        }
        if ((contact = info.getContact()) != null) {
            this.resolveProperty(contact::getName, contact::name, this.propertyResolverUtils, locale);
            this.resolveProperty(contact::getEmail, contact::email, this.propertyResolverUtils, locale);
            this.resolveProperty(contact::getUrl, contact::url, this.propertyResolverUtils, locale);
        }
        if (this.propertyResolverUtils.isResolveExtensionsProperties() && extensions != null) {
            Map<String, Object> extensionsResolved = this.propertyResolverUtils.resolveExtensions(locale, extensions);
            if (this.propertyResolverUtils.isOpenapi31()) {
                extensionsResolved.forEach(info::addExtension31);
            } else {
                info.setExtensions(extensionsResolved);
            }
        }
        return info;
    }

    private void resolveProperty(Supplier<String> getProperty, Consumer<String> setProperty, PropertyResolverUtils propertyResolverUtils, Locale locale) {
        String value = getProperty.get();
        if (StringUtils.isNotBlank(value)) {
            setProperty.accept(propertyResolverUtils.resolve(value, locale));
        }
    }

    private void calculateSecuritySchemes(Components components, Locale locale) {
        Map<String, Object> securitySchemeBeans = this.context.getBeansWithAnnotation(SecurityScheme.class);
        if (securitySchemeBeans.size() > 0) {
            for (Map.Entry<String, Object> entry : securitySchemeBeans.entrySet()) {
                Class<?> objClz = entry.getValue().getClass();
                Set<SecurityScheme> apiSecurityScheme = AnnotatedElementUtils.findMergedRepeatableAnnotations(objClz, SecurityScheme.class);
                this.addSecurityScheme(apiSecurityScheme, components, locale);
            }
        } else {
            ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
            scanner.addIncludeFilter(new AnnotationTypeFilter(SecuritySchemes.class));
            scanner.addIncludeFilter(new AnnotationTypeFilter(SecurityScheme.class));
            if (AutoConfigurationPackages.has(this.context)) {
                List<String> packagesToScan = AutoConfigurationPackages.get(this.context);
                Set<SecurityScheme> apiSecurityScheme = this.getSecuritySchemesClasses(scanner, packagesToScan);
                this.addSecurityScheme(apiSecurityScheme, components, locale);
            }
        }
    }

    private void addSecurityScheme(Set<SecurityScheme> apiSecurityScheme, Components components, Locale locale) {
        for (SecurityScheme securitySchemeAnnotation : apiSecurityScheme) {
            Optional<SecuritySchemePair> securityScheme = this.securityParser.getSecurityScheme(securitySchemeAnnotation, locale);
            if (!securityScheme.isPresent()) continue;
            HashMap<String, io.swagger.v3.oas.models.security.SecurityScheme> securitySchemeMap = new HashMap<String, io.swagger.v3.oas.models.security.SecurityScheme>();
            if (!StringUtils.isNotBlank(securityScheme.get().key())) continue;
            securitySchemeMap.put(securityScheme.get().key(), securityScheme.get().securityScheme());
            if (!CollectionUtils.isEmpty(components.getSecuritySchemes())) {
                components.getSecuritySchemes().putAll(securitySchemeMap);
                continue;
            }
            components.setSecuritySchemes(securitySchemeMap);
        }
    }

    private OpenAPIDefinition getApiDefClass(ClassPathScanningCandidateComponentProvider scanner, List<String> packagesToScan) {
        for (String pack : packagesToScan) {
            for (BeanDefinition bd : scanner.findCandidateComponents(pack)) {
                try {
                    return AnnotationUtils.findAnnotation(Class.forName(bd.getBeanClassName()), OpenAPIDefinition.class);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("Class Not Found in classpath : {}", (Object)e.getMessage());
                }
            }
        }
        return null;
    }

    public boolean isAutoTagClasses(Operation operation) {
        return CollectionUtils.isEmpty(operation.getTags()) && this.springDocConfigProperties.isAutoTagClasses();
    }

    private Set<SecurityScheme> getSecuritySchemesClasses(ClassPathScanningCandidateComponentProvider scanner, List<String> packagesToScan) {
        HashSet<SecurityScheme> apiSecurityScheme = new HashSet<SecurityScheme>();
        for (String pack : packagesToScan) {
            for (BeanDefinition bd : scanner.findCandidateComponents(pack)) {
                try {
                    apiSecurityScheme.add(AnnotationUtils.findAnnotation(Class.forName(bd.getBeanClassName()), SecurityScheme.class));
                    SecuritySchemes apiSecuritySchemes = AnnotationUtils.findAnnotation(Class.forName(bd.getBeanClassName()), SecuritySchemes.class);
                    if (apiSecuritySchemes == null || ArrayUtils.isEmpty(apiSecuritySchemes.value())) continue;
                    Arrays.stream(apiSecuritySchemes.value()).forEach(apiSecurityScheme::add);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("Class Not Found in classpath : {}", (Object)e.getMessage());
                }
            }
        }
        return apiSecurityScheme;
    }

    public void addTag(Set<HandlerMethod> handlerMethods, io.swagger.v3.oas.models.tags.Tag tag) {
        handlerMethods.forEach(handlerMethod -> this.springdocTags.put((HandlerMethod)handlerMethod, tag));
    }

    public Map<String, Object> getMappingsMap() {
        return this.mappingsMap;
    }

    public void addMappings(Map<String, Object> mappings) {
        this.mappingsMap.putAll(mappings);
    }

    public Map<String, Object> getControllerAdviceMap() {
        Map<String, Object> controllerAdviceMap = this.context.getBeansWithAnnotation(ControllerAdvice.class);
        return Stream.of(controllerAdviceMap).flatMap(mapEl -> mapEl.entrySet().stream()).filter(controller -> AnnotationUtils.findAnnotation(controller.getValue().getClass(), Hidden.class) == null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a1, a2) -> a1, LinkedHashMap::new));
    }

    public OpenAPI getCachedOpenAPI(Locale locale) {
        return this.cachedOpenAPI.get(locale.toLanguageTag());
    }

    public void setCachedOpenAPI(OpenAPI cachedOpenAPI, Locale locale) {
        this.cachedOpenAPI.put(locale.toLanguageTag(), cachedOpenAPI);
    }

    public ApplicationContext getContext() {
        return this.context;
    }

    public SecurityService getSecurityParser() {
        return this.securityParser;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }
}

