/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.providers;

import com.hazelcast.shaded.com.fasterxml.jackson.databind.Module;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.PostConstruct;
import java.util.Optional;
import org.springdoc.core.providers.HateoasHalProvider;
import org.springdoc.core.providers.ObjectMapperProvider;
import org.springframework.boot.autoconfigure.hateoas.HateoasProperties;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.hateoas.mediatype.hal.Jackson2HalModule;

public class DataRestHalProvider
extends HateoasHalProvider {
    private final Optional<RepositoryRestConfiguration> repositoryRestConfigurationOptional;

    public DataRestHalProvider(Optional<RepositoryRestConfiguration> repositoryRestConfigurationOptional, Optional<HateoasProperties> hateoasPropertiesOptional, ObjectMapperProvider objectMapperProvider) {
        super(hateoasPropertiesOptional, objectMapperProvider);
        this.repositoryRestConfigurationOptional = repositoryRestConfigurationOptional;
    }

    @Override
    @PostConstruct
    protected void init() {
        if (!this.isHalEnabled()) {
            return;
        }
        if (!Jackson2HalModule.isAlreadyRegisteredIn((ObjectMapper)this.objectMapperProvider.jsonMapper())) {
            this.objectMapperProvider.jsonMapper().registerModule((Module)new Jackson2HalModule());
        }
    }

    @Override
    public boolean isHalEnabled() {
        return this.repositoryRestConfigurationOptional.map(RepositoryRestConfiguration::useHalAsDefaultJsonMediaType).orElse(true);
    }
}

