/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.models;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.customizers.OpenApiCustomizer;
import org.springdoc.core.customizers.OperationCustomizer;
import org.springdoc.core.customizers.RouterOperationCustomizer;
import org.springdoc.core.filters.OpenApiMethodFilter;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class GroupedOpenApi {
    private final String group;
    private final List<String> pathsToMatch;
    private final List<String> packagesToScan;
    private final List<String> packagesToExclude;
    private final List<String> pathsToExclude;
    private final List<String> producesToMatch;
    private final List<String> headersToMatch;
    private final List<String> consumesToMatch;
    private final String displayName;
    private Set<OpenApiCustomizer> openApiCustomizers;
    private Set<OperationCustomizer> operationCustomizers;
    private Set<RouterOperationCustomizer> routerOperationCustomizers;
    private Set<OpenApiMethodFilter> openApiMethodFilters;

    private GroupedOpenApi(Builder builder) {
        Assert.isTrue(StringUtils.isNotBlank(builder.group), "Group name can not be null or empty");
        this.group = builder.group;
        this.pathsToMatch = builder.pathsToMatch;
        this.packagesToScan = builder.packagesToScan;
        this.producesToMatch = builder.producesToMatch;
        this.consumesToMatch = builder.consumesToMatch;
        this.headersToMatch = builder.headersToMatch;
        this.packagesToExclude = builder.packagesToExclude;
        this.pathsToExclude = builder.pathsToExclude;
        this.displayName = StringUtils.defaultIfEmpty(builder.displayName, this.group);
        this.openApiCustomizers = Objects.requireNonNull(builder.openApiCustomizers);
        this.operationCustomizers = Objects.requireNonNull(builder.operationCustomizers);
        this.routerOperationCustomizers = Objects.requireNonNull(builder.routerOperationCustomizers);
        this.openApiMethodFilters = Objects.requireNonNull(builder.methodFilters);
        if (CollectionUtils.isEmpty(this.pathsToMatch) && CollectionUtils.isEmpty(this.packagesToScan) && CollectionUtils.isEmpty(this.producesToMatch) && CollectionUtils.isEmpty(this.consumesToMatch) && CollectionUtils.isEmpty(this.headersToMatch) && CollectionUtils.isEmpty(this.pathsToExclude) && CollectionUtils.isEmpty(this.packagesToExclude) && CollectionUtils.isEmpty(this.openApiCustomizers) && CollectionUtils.isEmpty(this.operationCustomizers) && CollectionUtils.isEmpty(this.openApiMethodFilters)) {
            throw new IllegalStateException("Packages to scan or paths to filter or openApiCustomizers/operationCustomizers can not be all null for the group:" + this.group);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<String> getProducesToMatch() {
        return this.producesToMatch;
    }

    public List<String> getHeadersToMatch() {
        return this.headersToMatch;
    }

    public List<String> getConsumesToMatch() {
        return this.consumesToMatch;
    }

    public String getGroup() {
        return this.group;
    }

    public List<String> getPathsToMatch() {
        return this.pathsToMatch;
    }

    public List<String> getPackagesToScan() {
        return this.packagesToScan;
    }

    public List<String> getPackagesToExclude() {
        return this.packagesToExclude;
    }

    public List<String> getPathsToExclude() {
        return this.pathsToExclude;
    }

    public Set<OpenApiCustomizer> getOpenApiCustomizers() {
        return this.openApiCustomizers;
    }

    public Set<OperationCustomizer> getOperationCustomizers() {
        return this.operationCustomizers;
    }

    public Set<OpenApiMethodFilter> getOpenApiMethodFilters() {
        return this.openApiMethodFilters;
    }

    public Set<RouterOperationCustomizer> getRouterOperationCustomizers() {
        return this.routerOperationCustomizers;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public GroupedOpenApi addAllOpenApiCustomizer(Collection<? extends OpenApiCustomizer> openApiCustomizerCollection) {
        LinkedHashSet<OpenApiCustomizer> result = new LinkedHashSet<OpenApiCustomizer>();
        result.addAll(openApiCustomizerCollection);
        result.addAll(this.openApiCustomizers);
        this.openApiCustomizers = result;
        return this;
    }

    public GroupedOpenApi addAllOperationCustomizer(Collection<? extends OperationCustomizer> operationCustomizerCollection) {
        LinkedHashSet<OperationCustomizer> result = new LinkedHashSet<OperationCustomizer>();
        result.addAll(operationCustomizerCollection);
        result.addAll(this.operationCustomizers);
        this.operationCustomizers = result;
        return this;
    }

    public GroupedOpenApi addAllOpenApiMethodFilter(Collection<? extends OpenApiMethodFilter> openApiMethodFilterCollection) {
        LinkedHashSet<OpenApiMethodFilter> result = new LinkedHashSet<OpenApiMethodFilter>();
        result.addAll(openApiMethodFilterCollection);
        result.addAll(this.openApiMethodFilters);
        this.openApiMethodFilters = result;
        return this;
    }

    public static class Builder {
        private final Set<OpenApiCustomizer> openApiCustomizers = new LinkedHashSet<OpenApiCustomizer>();
        private final Set<OperationCustomizer> operationCustomizers = new LinkedHashSet<OperationCustomizer>();
        private final Set<RouterOperationCustomizer> routerOperationCustomizers = new LinkedHashSet<RouterOperationCustomizer>();
        private final Set<OpenApiMethodFilter> methodFilters = new LinkedHashSet<OpenApiMethodFilter>();
        private String group;
        private List<String> pathsToMatch;
        private List<String> packagesToScan;
        private List<String> packagesToExclude;
        private List<String> pathsToExclude;
        private List<String> producesToMatch;
        private List<String> headersToMatch;
        private List<String> consumesToMatch;
        private String displayName;

        private Builder() {
        }

        public Builder group(String group) {
            this.group = group;
            return this;
        }

        public Builder pathsToMatch(String ... pathsToMatch) {
            this.pathsToMatch = Arrays.asList(pathsToMatch);
            return this;
        }

        public Builder packagesToScan(String ... packagesToScan) {
            this.packagesToScan = Arrays.asList(packagesToScan);
            return this;
        }

        public Builder producesToMatch(String ... producesToMatch) {
            this.producesToMatch = Arrays.asList(producesToMatch);
            return this;
        }

        public Builder consumesToMatch(String ... consumesToMatch) {
            this.consumesToMatch = Arrays.asList(consumesToMatch);
            return this;
        }

        public Builder headersToMatch(String ... headersToMatch) {
            this.headersToMatch = Arrays.asList(headersToMatch);
            return this;
        }

        public Builder pathsToExclude(String ... pathsToExclude) {
            this.pathsToExclude = Arrays.asList(pathsToExclude);
            return this;
        }

        public Builder packagesToExclude(String ... packagesToExclude) {
            this.packagesToExclude = Arrays.asList(packagesToExclude);
            return this;
        }

        public Builder addOpenApiCustomizer(OpenApiCustomizer openApiCustomizer) {
            this.openApiCustomizers.add(openApiCustomizer);
            return this;
        }

        public Builder addOperationCustomizer(OperationCustomizer operationCustomizer) {
            this.operationCustomizers.add(operationCustomizer);
            return this;
        }

        public Builder addRouterOperationCustomizer(RouterOperationCustomizer routerOperationCustomizer) {
            this.routerOperationCustomizers.add(routerOperationCustomizer);
            return this;
        }

        public Builder addOpenApiMethodFilter(OpenApiMethodFilter methodFilter) {
            this.methodFilters.add(methodFilter);
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public GroupedOpenApi build() {
            return new GroupedOpenApi(this);
        }
    }
}

