/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.fn.builders.parameter;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.Explode;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.enums.ParameterStyle;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import java.lang.annotation.Annotation;
import org.apache.commons.lang3.ArrayUtils;

public class Builder {
    private String name = "";
    private ParameterIn in = ParameterIn.DEFAULT;
    private String description = "";
    private boolean required;
    private boolean deprecated;
    private boolean allowEmptyValue;
    private ParameterStyle style = ParameterStyle.DEFAULT;
    private Explode explode = Explode.DEFAULT;
    private boolean allowReserved;
    private Schema schema = org.springdoc.core.fn.builders.schema.Builder.schemaBuilder().build();
    private ArraySchema array = org.springdoc.core.fn.builders.arrayschema.Builder.arraySchemaBuilder().build();
    private Content[] content = new Content[0];
    private boolean hidden;
    private ExampleObject[] examples = new ExampleObject[0];
    private String example = "";
    private Extension[] extensions = new Extension[0];
    private String ref = "";
    private Class<?>[] validationGroups = new Class[0];

    private Builder() {
    }

    public static Builder parameterBuilder() {
        return new Builder();
    }

    public Builder name(String name) {
        this.name = name;
        return this;
    }

    public Builder in(ParameterIn in) {
        this.in = in;
        return this;
    }

    public Builder description(String description) {
        this.description = description;
        return this;
    }

    public Builder required(boolean required) {
        this.required = required;
        return this;
    }

    public Builder deprecated(boolean deprecated) {
        this.deprecated = deprecated;
        return this;
    }

    public Builder allowEmptyValue(boolean allowEmptyValue) {
        this.allowEmptyValue = allowEmptyValue;
        return this;
    }

    public Builder style(ParameterStyle style) {
        this.style = style;
        return this;
    }

    public Builder explode(Explode explode) {
        this.explode = explode;
        return this;
    }

    public Builder allowReserved(boolean allowReserved) {
        this.allowReserved = allowReserved;
        return this;
    }

    public Builder schema(org.springdoc.core.fn.builders.schema.Builder schemaBuilder) {
        this.schema = schemaBuilder.build();
        return this;
    }

    public Builder array(org.springdoc.core.fn.builders.arrayschema.Builder arraySchemaBuilder) {
        this.array = arraySchemaBuilder.build();
        return this;
    }

    public Builder implementationArray(Class clazz) {
        this.array = org.springdoc.core.fn.builders.arrayschema.Builder.arraySchemaBuilder().schema(org.springdoc.core.fn.builders.schema.Builder.schemaBuilder().implementation(clazz)).build();
        return this;
    }

    public Builder implementation(Class clazz) {
        this.schema = org.springdoc.core.fn.builders.schema.Builder.schemaBuilder().implementation(clazz).build();
        return this;
    }

    public Builder content(org.springdoc.core.fn.builders.content.Builder contentBuilder) {
        this.content = ArrayUtils.add(this.content, contentBuilder.build());
        return this;
    }

    public Builder hidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public Builder examples(org.springdoc.core.fn.builders.exampleobject.Builder exampleObjectBuilder) {
        this.examples = ArrayUtils.add(this.examples, exampleObjectBuilder.build());
        return this;
    }

    public Builder example(String example) {
        this.example = example;
        return this;
    }

    public Builder extensions(org.springdoc.core.fn.builders.extension.Builder extensionBuilder) {
        this.extensions = ArrayUtils.add(this.extensions, extensionBuilder.build());
        return this;
    }

    public Builder ref(String ref) {
        this.ref = ref;
        return this;
    }

    public Parameter build() {
        return new Parameter(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return null;
            }

            @Override
            public String name() {
                return Builder.this.name;
            }

            @Override
            public ParameterIn in() {
                return Builder.this.in;
            }

            @Override
            public String description() {
                return Builder.this.description;
            }

            @Override
            public boolean required() {
                return Builder.this.required;
            }

            @Override
            public boolean deprecated() {
                return Builder.this.deprecated;
            }

            @Override
            public boolean allowEmptyValue() {
                return Builder.this.allowEmptyValue;
            }

            @Override
            public ParameterStyle style() {
                return Builder.this.style;
            }

            @Override
            public Explode explode() {
                return Builder.this.explode;
            }

            @Override
            public boolean allowReserved() {
                return Builder.this.allowReserved;
            }

            @Override
            public Schema schema() {
                return Builder.this.schema;
            }

            @Override
            public ArraySchema array() {
                return Builder.this.array;
            }

            @Override
            public Content[] content() {
                return Builder.this.content;
            }

            @Override
            public boolean hidden() {
                return Builder.this.hidden;
            }

            @Override
            public ExampleObject[] examples() {
                return Builder.this.examples;
            }

            @Override
            public String example() {
                return Builder.this.example;
            }

            @Override
            public Extension[] extensions() {
                return Builder.this.extensions;
            }

            @Override
            public String ref() {
                return Builder.this.ref;
            }

            @Override
            public Class<?>[] validationGroups() {
                return Builder.this.validationGroups;
            }
        };
    }
}

