/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.data;

import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.tags.Tag;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.springdoc.core.data.DataRestRepository;
import org.springdoc.core.service.OpenAPIService;
import org.springdoc.core.service.SecurityService;
import org.springframework.data.rest.webmvc.ProfileController;
import org.springframework.data.rest.webmvc.alps.AlpsController;
import org.springframework.util.CollectionUtils;
import org.springframework.web.method.HandlerMethod;

public class DataRestTagsService {
    private final OpenAPIService openAPIService;

    public DataRestTagsService(OpenAPIService openAPIService) {
        this.openAPIService = openAPIService;
    }

    public void buildSearchTags(Operation operation, HandlerMethod handlerMethod, DataRestRepository dataRestRepository, Method method) {
        this.buildTags(operation, handlerMethod, dataRestRepository, method);
    }

    public void buildEntityTags(Operation operation, HandlerMethod handlerMethod, DataRestRepository dataRestRepository) {
        this.buildTags(operation, handlerMethod, dataRestRepository, null);
    }

    private void buildTags(Operation operation, HandlerMethod handlerMethod, DataRestRepository dataRestRepository, Method method) {
        String tagName = handlerMethod.getBeanType().getSimpleName();
        if ("org.springframework.data.rest.webmvc.RepositorySchemaController".equals(handlerMethod.getBeanType().getName()) || AlpsController.class.equals(handlerMethod.getBeanType()) || ProfileController.class.equals(handlerMethod.getBeanType())) {
            tagName = ProfileController.class.getSimpleName();
            operation.addTagsItem(OpenAPIService.splitCamelCase(tagName));
        } else {
            Class<?> domainType = dataRestRepository.getDomainType();
            HashSet<Tag> tags = new HashSet<Tag>();
            HashSet<String> tagsStr = new HashSet<String>();
            Class<?> repositoryType = dataRestRepository.getRepositoryType();
            this.openAPIService.buildTagsFromClass(repositoryType, tags, tagsStr, dataRestRepository.getLocale());
            if (!CollectionUtils.isEmpty(tagsStr)) {
                tagsStr.forEach(operation::addTagsItem);
            } else {
                tagName = tagName.replace("Repository", domainType.getSimpleName());
                operation.addTagsItem(OpenAPIService.splitCamelCase(tagName));
            }
            SecurityService securityParser = this.openAPIService.getSecurityParser();
            Set<SecurityRequirement> allSecurityTags = securityParser.getSecurityRequirementsForClass(repositoryType);
            if (method != null) {
                allSecurityTags = securityParser.getSecurityRequirementsForMethod(method, allSecurityTags);
            }
            if (!CollectionUtils.isEmpty(allSecurityTags)) {
                securityParser.buildSecurityRequirement(allSecurityTags.toArray(new SecurityRequirement[0]), operation);
            }
        }
    }
}

