/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.customizers;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.springdoc.core.customizers.DataRestRouterOperationCustomizer;
import org.springdoc.core.customizers.GlobalOpenApiCustomizer;
import org.springdoc.core.customizers.GlobalOperationCustomizer;
import org.springdoc.core.customizers.OpenApiCustomizer;
import org.springdoc.core.customizers.OperationCustomizer;
import org.springdoc.core.customizers.RouterOperationCustomizer;
import org.springdoc.core.filters.GlobalOpenApiMethodFilter;
import org.springdoc.core.filters.OpenApiMethodFilter;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.CollectionUtils;

public class SpringDocCustomizers
implements ApplicationContextAware,
InitializingBean {
    private final Optional<Set<OpenApiCustomizer>> openApiCustomizers;
    private final Optional<Set<OperationCustomizer>> operationCustomizers;
    private final Optional<Set<RouterOperationCustomizer>> routerOperationCustomizers;
    private final Optional<Set<DataRestRouterOperationCustomizer>> dataRestRouterOperationCustomizers;
    private ApplicationContext context;
    private final Optional<Set<OpenApiMethodFilter>> methodFilters;
    private Optional<Set<GlobalOpenApiCustomizer>> globalOpenApiCustomizers;
    private Optional<Set<GlobalOperationCustomizer>> globalOperationCustomizers;
    private Optional<Set<GlobalOpenApiMethodFilter>> globalOpenApiMethodFilters;

    public SpringDocCustomizers(Optional<Set<OpenApiCustomizer>> openApiCustomizers, Optional<Set<OperationCustomizer>> operationCustomizers, Optional<Set<RouterOperationCustomizer>> routerOperationCustomizers, Optional<Set<DataRestRouterOperationCustomizer>> dataRestRouterOperationCustomizers, Optional<Set<OpenApiMethodFilter>> methodFilters, Optional<Set<GlobalOpenApiCustomizer>> globalOpenApiCustomizers, Optional<Set<GlobalOperationCustomizer>> globalOperationCustomizers, Optional<Set<GlobalOpenApiMethodFilter>> globalOpenApiMethodFilters) {
        this.openApiCustomizers = openApiCustomizers;
        this.operationCustomizers = operationCustomizers;
        this.globalOpenApiCustomizers = globalOpenApiCustomizers;
        this.globalOperationCustomizers = globalOperationCustomizers;
        this.globalOpenApiMethodFilters = globalOpenApiMethodFilters;
        operationCustomizers.ifPresent(customizers -> customizers.removeIf(Objects::isNull));
        this.routerOperationCustomizers = routerOperationCustomizers;
        this.dataRestRouterOperationCustomizers = dataRestRouterOperationCustomizers;
        this.methodFilters = methodFilters;
    }

    public SpringDocCustomizers(Optional<Set<OpenApiCustomizer>> openApiCustomizers, Optional<Set<OperationCustomizer>> operationCustomizers, Optional<Set<RouterOperationCustomizer>> routerOperationCustomizers, Optional<Set<OpenApiMethodFilter>> openApiMethodFilters) {
        this.openApiCustomizers = openApiCustomizers;
        this.operationCustomizers = operationCustomizers;
        this.routerOperationCustomizers = routerOperationCustomizers;
        this.methodFilters = openApiMethodFilters;
        this.dataRestRouterOperationCustomizers = Optional.empty();
    }

    public Optional<Set<OpenApiCustomizer>> getOpenApiCustomizers() {
        return this.openApiCustomizers;
    }

    public Optional<Set<OperationCustomizer>> getOperationCustomizers() {
        return this.operationCustomizers;
    }

    public Optional<Set<RouterOperationCustomizer>> getRouterOperationCustomizers() {
        return this.routerOperationCustomizers;
    }

    public Optional<Set<DataRestRouterOperationCustomizer>> getDataRestRouterOperationCustomizers() {
        return this.dataRestRouterOperationCustomizers;
    }

    public Optional<Set<OpenApiMethodFilter>> getMethodFilters() {
        return this.methodFilters;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public Optional<Set<GlobalOpenApiCustomizer>> getGlobalOpenApiCustomizers() {
        return this.globalOpenApiCustomizers;
    }

    public Optional<Set<GlobalOperationCustomizer>> getGlobalOperationCustomizers() {
        return this.globalOperationCustomizers;
    }

    public Optional<Set<GlobalOpenApiMethodFilter>> getGlobalOpenApiMethodFilters() {
        return this.globalOpenApiMethodFilters;
    }

    @Override
    public void afterPropertiesSet() {
        Map<String, OpenApiCustomizer> existingOpenApiCustomizers = this.context.getBeansOfType(OpenApiCustomizer.class);
        if (!CollectionUtils.isEmpty(existingOpenApiCustomizers) && existingOpenApiCustomizers.containsKey("linksSchemaCustomizer")) {
            this.openApiCustomizers.ifPresent(openApiCustomizersList -> openApiCustomizersList.add((OpenApiCustomizer)existingOpenApiCustomizers.get("linksSchemaCustomizer")));
        }
    }
}

