/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.customizers;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.security.OAuthFlows;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.customizers.GlobalOpenApiCustomizer;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springframework.util.CollectionUtils;

public class SpecPropertiesCustomizer
implements GlobalOpenApiCustomizer {
    private final OpenAPI openApiProperties;

    public SpecPropertiesCustomizer(SpringDocConfigProperties springDocConfigProperties) {
        this.openApiProperties = springDocConfigProperties.getOpenApi();
    }

    public SpecPropertiesCustomizer(OpenAPI openApiProperties) {
        this.openApiProperties = openApiProperties;
    }

    @Override
    public void customise(OpenAPI openApi) {
        this.customizeOpenApi(openApi, this.openApiProperties);
    }

    private void customizeOpenApi(OpenAPI openApi, OpenAPI openApiProperties) {
        if (openApiProperties != null) {
            List<SecurityRequirement> securityRequirementsProperties;
            Paths pathsProperties;
            Components componentsProperties;
            Info infoProperties = openApiProperties.getInfo();
            if (infoProperties != null) {
                this.customizeInfo(openApi, infoProperties);
            }
            if ((componentsProperties = openApiProperties.getComponents()) != null) {
                this.customizeComponents(openApi, componentsProperties);
            }
            if ((pathsProperties = openApiProperties.getPaths()) != null) {
                this.customizePaths(openApi, pathsProperties);
            }
            if (!CollectionUtils.isEmpty(securityRequirementsProperties = openApiProperties.getSecurity())) {
                this.customizeSecurity(openApi, securityRequirementsProperties);
            }
            if (!CollectionUtils.isEmpty(openApiProperties.getServers())) {
                openApi.setServers(new ArrayList<Server>(openApiProperties.getServers()));
            }
        }
    }

    private void customizeSecurity(OpenAPI openApi, List<SecurityRequirement> securityRequirementsProperties) {
        List<SecurityRequirement> securityRequirements = openApi.getSecurity();
        if (CollectionUtils.isEmpty(securityRequirements)) {
            openApi.setSecurity(securityRequirementsProperties);
        } else {
            securityRequirementsProperties.forEach(securityRequirement -> {
                if (!securityRequirements.contains(securityRequirement)) {
                    securityRequirements.add((SecurityRequirement)securityRequirement);
                }
            });
        }
    }

    private void customizePaths(OpenAPI openApi, Paths pathsProperties) {
        Paths paths = openApi.getPaths();
        if (paths == null) {
            openApi.paths(pathsProperties);
        } else {
            paths.forEach((path, pathItem) -> {
                PathItem pathItemProperties;
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if ((pathItemProperties = (PathItem)pathsProperties.get(path)) != null) {
                    this.resolveString(pathItem::description, pathItemProperties::getDescription);
                    this.resolveString(pathItem::summary, pathItemProperties::getSummary);
                    Map<PathItem.HttpMethod, Operation> operationMap = pathItem.readOperationsMap();
                    Map<PathItem.HttpMethod, Operation> operationMapProperties = pathItemProperties.readOperationsMap();
                    operationMapProperties.forEach((httpMethod, operationProperties) -> {
                        Operation operationToCustomize = (Operation)operationMap.get(httpMethod);
                        if (operationToCustomize != null) {
                            this.resolveString(operationToCustomize::description, operationProperties::getDescription);
                            this.resolveString(operationToCustomize::summary, operationProperties::getSummary);
                            this.resolveSet(operationToCustomize::tags, operationProperties::getTags);
                        }
                    });
                }
            });
        }
    }

    private void customizeComponents(OpenAPI openApi, Components componentsProperties) {
        Components components = openApi.getComponents();
        if (components == null || CollectionUtils.isEmpty(components.getSchemas())) {
            openApi.components(componentsProperties);
        } else {
            Map<String, Schema> schemaMap = components.getSchemas();
            schemaMap.forEach((key, schema) -> {
                Schema schemaProperties;
                if (!CollectionUtils.isEmpty(componentsProperties.getSchemas()) && (schemaProperties = componentsProperties.getSchemas().get(key)) != null) {
                    this.resolveString(schema::setDescription, schemaProperties::getDescription);
                    Map<String, Schema> properties = schema.getProperties();
                    if (CollectionUtils.isEmpty(properties)) {
                        return;
                    }
                    properties.forEach((propKey, propSchema) -> {
                        Schema propSchemaProperties = schemaProperties.getProperties().get(propKey);
                        if (propSchemaProperties != null) {
                            this.resolveString(propSchema::description, propSchemaProperties::getDescription);
                            this.resolveString(propSchema::title, propSchemaProperties::getTitle);
                            this.resolveString(propSchema::example, propSchemaProperties::getExample);
                        }
                    });
                }
            });
            Map<String, SecurityScheme> securitySchemeMap = components.getSecuritySchemes();
            if (CollectionUtils.isEmpty(securitySchemeMap)) {
                components.setSecuritySchemes(componentsProperties.getSecuritySchemes());
            } else {
                securitySchemeMap.forEach((key, securityScheme) -> {
                    SecurityScheme securitySchemeToCustomize = components.getSecuritySchemes().get(key);
                    if (securitySchemeToCustomize != null) {
                        this.resolveString(securitySchemeToCustomize::description, securityScheme::getDescription);
                        this.resolveString(securitySchemeToCustomize::name, securityScheme::getName);
                        this.resolveType(securitySchemeToCustomize::type, securityScheme::getType);
                        this.resolveIn(securitySchemeToCustomize::in, securityScheme::getIn);
                        this.resolveString(securitySchemeToCustomize::scheme, securityScheme::getScheme);
                        this.resolveString(securitySchemeToCustomize::bearerFormat, securityScheme::getBearerFormat);
                        this.resolveString(securitySchemeToCustomize::openIdConnectUrl, securityScheme::getOpenIdConnectUrl);
                        this.resolveOAuthFlows(securitySchemeToCustomize::flows, securityScheme::getFlows);
                        this.resolveString(securitySchemeToCustomize::$ref, securityScheme::get$ref);
                    }
                });
            }
        }
    }

    private void customizeInfo(OpenAPI openApi, Info infoProperties) {
        Info info = openApi.getInfo();
        if (info != null) {
            this.resolveString(info::title, infoProperties::getTitle);
            this.resolveString(info::description, infoProperties::getDescription);
            this.resolveString(info::version, infoProperties::getVersion);
            this.resolveString(info::termsOfService, infoProperties::getTermsOfService);
            this.resolveString(info::summary, infoProperties::getSummary);
            License license = info.getLicense();
            License licenseProperties = infoProperties.getLicense();
            if (license != null) {
                this.resolveString(license::name, licenseProperties::getName);
                this.resolveString(license::url, licenseProperties::getUrl);
            } else {
                info.license(licenseProperties);
            }
            Contact contact = info.getContact();
            Contact contactProperties = infoProperties.getContact();
            if (contact != null) {
                this.resolveString(contact::name, contactProperties::getName);
                this.resolveString(contact::email, contactProperties::getEmail);
                this.resolveString(contact::url, contactProperties::getUrl);
            } else {
                info.contact(contactProperties);
            }
        } else {
            openApi.info(infoProperties);
        }
    }

    private void resolveString(Consumer<String> setter, Supplier<Object> getter) {
        String value = (String)getter.get();
        if (StringUtils.isNotBlank(value)) {
            setter.accept(value);
        }
    }

    private void resolveType(Consumer<SecurityScheme.Type> setter, Supplier<Object> getter) {
        SecurityScheme.Type value = (SecurityScheme.Type)((Object)getter.get());
        if (value != null) {
            setter.accept(value);
        }
    }

    private void resolveIn(Consumer<SecurityScheme.In> setter, Supplier<Object> getter) {
        SecurityScheme.In value = (SecurityScheme.In)((Object)getter.get());
        if (value != null) {
            setter.accept(value);
        }
    }

    private void resolveOAuthFlows(Consumer<OAuthFlows> setter, Supplier<Object> getter) {
        OAuthFlows value = (OAuthFlows)getter.get();
        if (value != null) {
            setter.accept(value);
        }
    }

    private void resolveSet(Consumer<List> setter, Supplier<List> getter) {
        List value = getter.get();
        if (!CollectionUtils.isEmpty(value)) {
            setter.accept(value);
        }
    }
}

