/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.customizers;

import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverters;
import io.swagger.v3.core.converter.ResolvedSchema;
import io.swagger.v3.core.filter.SpecFilter;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.lang.reflect.Type;
import org.springdoc.core.customizers.GlobalOpenApiCustomizer;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springframework.hateoas.Link;

public class OpenApiHateoasLinksCustomizer
extends SpecFilter
implements GlobalOpenApiCustomizer {
    private final SpringDocConfigProperties springDocConfigProperties;

    public OpenApiHateoasLinksCustomizer(SpringDocConfigProperties springDocConfigProperties) {
        this.springDocConfigProperties = springDocConfigProperties;
    }

    @Override
    public void customise(OpenAPI openApi) {
        ResolvedSchema resolvedLinkSchema = ModelConverters.getInstance(this.springDocConfigProperties.isOpenapi31()).resolveAsResolvedSchema(new AnnotatedType((Type)((Object)Link.class)));
        openApi.schema("Link", resolvedLinkSchema.schema).schema("Links", new MapSchema().additionalProperties(new StringSchema()).additionalProperties(new Schema().$ref("#/components/schemas/Link")));
        if (this.springDocConfigProperties.isRemoveBrokenReferenceDefinitions()) {
            this.removeBrokenReferenceDefinitions(openApi);
        }
    }
}

