/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.customizers;

import com.hazelcast.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.v3.core.util.ObjectMapperFactory;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.StringToClassMapItem;
import io.swagger.v3.oas.annotations.enums.Explode;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.enums.ParameterStyle;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.DependentRequired;
import io.swagger.v3.oas.annotations.media.DiscriminatorMapping;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.customizers.DelegatingMethodParameterCustomizer;
import org.springdoc.core.providers.RepositoryRestConfigurationProvider;
import org.springdoc.core.providers.SpringDataWebPropertiesProvider;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.data.web.SortDefault;

public class DataRestDelegatingMethodParameterCustomizer
implements DelegatingMethodParameterCustomizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataRestDelegatingMethodParameterCustomizer.class);
    private final Optional<SpringDataWebPropertiesProvider> optionalSpringDataWebPropertiesProvider;
    private final Optional<RepositoryRestConfigurationProvider> optionalRepositoryRestConfigurationProvider;

    public DataRestDelegatingMethodParameterCustomizer(Optional<SpringDataWebPropertiesProvider> optionalSpringDataWebPropertiesProvider, Optional<RepositoryRestConfigurationProvider> optionalRepositoryRestConfigurationProvider) {
        this.optionalSpringDataWebPropertiesProvider = optionalSpringDataWebPropertiesProvider;
        this.optionalRepositoryRestConfigurationProvider = optionalRepositoryRestConfigurationProvider;
    }

    @Override
    public void customize(MethodParameter originalParameter, MethodParameter methodParameter) {
        PageableDefault pageableDefault = originalParameter.getParameterAnnotation(PageableDefault.class);
        SortDefault sortDefault = originalParameter.getParameterAnnotation(SortDefault.class);
        Class<?> parameterType = originalParameter.getParameterType();
        if (pageableDefault != null || sortDefault != null || (Pageable.class.isAssignableFrom(parameterType) || Sort.class.isAssignableFrom(parameterType)) && (this.isSpringDataWebPropertiesPresent() || this.isRepositoryRestConfigurationPresent())) {
            try {
                Annotation[] parameterAnnotations = (Annotation[])FieldUtils.readDeclaredField(methodParameter, "additionalParameterAnnotations", true);
                if (ArrayUtils.isNotEmpty(parameterAnnotations)) {
                    for (int i2 = 0; i2 < parameterAnnotations.length; ++i2) {
                        Optional<Annotation> annotationForField;
                        if (!Parameter.class.equals(parameterAnnotations[i2].annotationType()) || !(annotationForField = this.getNewParameterAnnotationForField(methodParameter, pageableDefault, sortDefault)).isPresent()) continue;
                        parameterAnnotations[i2] = annotationForField.get();
                    }
                }
            }
            catch (IllegalAccessException e) {
                LOGGER.warn(e.getMessage());
            }
        }
    }

    private Optional<Annotation> getNewParameterAnnotationForField(MethodParameter methodParameter, final PageableDefault pageableDefault, final SortDefault sortDefault) {
        final String parameterName = methodParameter.getParameterName();
        try {
            final Parameter parameter = methodParameter.getContainingClass().getDeclaredField(parameterName).getAnnotation(Parameter.class);
            Parameter parameterNew = new Parameter(){

                @Override
                public Class<? extends Annotation> annotationType() {
                    return parameter.annotationType();
                }

                @Override
                public String name() {
                    return DataRestDelegatingMethodParameterCustomizer.this.getName(parameterName, parameter.name());
                }

                @Override
                public ParameterIn in() {
                    return parameter.in();
                }

                @Override
                public String description() {
                    return DataRestDelegatingMethodParameterCustomizer.this.getDescription(parameterName, parameter.description());
                }

                @Override
                public boolean required() {
                    return parameter.required();
                }

                @Override
                public boolean deprecated() {
                    return parameter.deprecated();
                }

                @Override
                public boolean allowEmptyValue() {
                    return parameter.allowEmptyValue();
                }

                @Override
                public ParameterStyle style() {
                    return parameter.style();
                }

                @Override
                public Explode explode() {
                    return parameter.explode();
                }

                @Override
                public boolean allowReserved() {
                    return parameter.allowReserved();
                }

                @Override
                public Schema schema() {
                    return new Schema(){
                        private Schema parameterSchema;
                        {
                            this.parameterSchema = parameter.schema();
                        }

                        @Override
                        public Schema.SchemaResolution schemaResolution() {
                            return this.parameterSchema.schemaResolution();
                        }

                        @Override
                        public Class<? extends Annotation> annotationType() {
                            return this.parameterSchema.annotationType();
                        }

                        @Override
                        public Class<?> implementation() {
                            return this.parameterSchema.implementation();
                        }

                        @Override
                        public Class<?> not() {
                            return this.parameterSchema.not();
                        }

                        @Override
                        public Class<?>[] oneOf() {
                            return this.parameterSchema.oneOf();
                        }

                        @Override
                        public Class<?>[] anyOf() {
                            return this.parameterSchema.anyOf();
                        }

                        @Override
                        public Class<?>[] allOf() {
                            return this.parameterSchema.allOf();
                        }

                        @Override
                        public String name() {
                            return this.parameterSchema.name();
                        }

                        @Override
                        public String title() {
                            return this.parameterSchema.title();
                        }

                        @Override
                        public double multipleOf() {
                            return this.parameterSchema.multipleOf();
                        }

                        @Override
                        public String maximum() {
                            return this.parameterSchema.maximum();
                        }

                        @Override
                        public boolean exclusiveMaximum() {
                            return this.parameterSchema.exclusiveMaximum();
                        }

                        @Override
                        public String minimum() {
                            return this.parameterSchema.minimum();
                        }

                        @Override
                        public boolean exclusiveMinimum() {
                            return this.parameterSchema.exclusiveMaximum();
                        }

                        @Override
                        public int maxLength() {
                            return this.parameterSchema.maxLength();
                        }

                        @Override
                        public int minLength() {
                            return this.parameterSchema.minLength();
                        }

                        @Override
                        public String pattern() {
                            return this.parameterSchema.pattern();
                        }

                        @Override
                        public int maxProperties() {
                            return this.parameterSchema.maxProperties();
                        }

                        @Override
                        public int minProperties() {
                            return this.parameterSchema.minProperties();
                        }

                        @Override
                        public String[] requiredProperties() {
                            return this.parameterSchema.requiredProperties();
                        }

                        @Override
                        public boolean required() {
                            return this.parameterSchema.required();
                        }

                        @Override
                        public Schema.RequiredMode requiredMode() {
                            return this.parameterSchema.requiredMode();
                        }

                        @Override
                        public String description() {
                            return this.parameterSchema.description();
                        }

                        @Override
                        public String format() {
                            return this.parameterSchema.format();
                        }

                        @Override
                        public String ref() {
                            return this.parameterSchema.ref();
                        }

                        @Override
                        public boolean nullable() {
                            return this.parameterSchema.nullable();
                        }

                        @Override
                        public boolean readOnly() {
                            return Schema.AccessMode.READ_ONLY.equals((Object)this.parameterSchema.accessMode());
                        }

                        @Override
                        public boolean writeOnly() {
                            return Schema.AccessMode.WRITE_ONLY.equals((Object)this.parameterSchema.accessMode());
                        }

                        @Override
                        public Schema.AccessMode accessMode() {
                            return this.parameterSchema.accessMode();
                        }

                        @Override
                        public String example() {
                            return this.parameterSchema.example();
                        }

                        @Override
                        public ExternalDocumentation externalDocs() {
                            return this.parameterSchema.externalDocs();
                        }

                        @Override
                        public boolean deprecated() {
                            return this.parameterSchema.deprecated();
                        }

                        @Override
                        public String type() {
                            return this.parameterSchema.type();
                        }

                        @Override
                        public String[] allowableValues() {
                            return this.parameterSchema.allowableValues();
                        }

                        @Override
                        public String defaultValue() {
                            return DataRestDelegatingMethodParameterCustomizer.this.getDefaultValue(parameterName, pageableDefault, this.parameterSchema.defaultValue());
                        }

                        @Override
                        public String discriminatorProperty() {
                            return this.parameterSchema.discriminatorProperty();
                        }

                        @Override
                        public DiscriminatorMapping[] discriminatorMapping() {
                            return this.parameterSchema.discriminatorMapping();
                        }

                        @Override
                        public boolean hidden() {
                            return this.parameterSchema.hidden();
                        }

                        @Override
                        public boolean enumAsRef() {
                            return this.parameterSchema.enumAsRef();
                        }

                        @Override
                        public Class<?>[] subTypes() {
                            return this.parameterSchema.subTypes();
                        }

                        @Override
                        public Extension[] extensions() {
                            return this.parameterSchema.extensions();
                        }

                        @Override
                        public Class<?>[] prefixItems() {
                            return this.parameterSchema.prefixItems();
                        }

                        @Override
                        public String[] types() {
                            return this.parameterSchema.types();
                        }

                        @Override
                        public int exclusiveMaximumValue() {
                            return this.parameterSchema.exclusiveMaximumValue();
                        }

                        @Override
                        public int exclusiveMinimumValue() {
                            return this.parameterSchema.exclusiveMinimumValue();
                        }

                        @Override
                        public Class<?> contains() {
                            return this.parameterSchema.contains();
                        }

                        @Override
                        public String $id() {
                            return this.parameterSchema.$id();
                        }

                        @Override
                        public String $schema() {
                            return this.parameterSchema.$schema();
                        }

                        @Override
                        public String $anchor() {
                            return this.parameterSchema.$anchor();
                        }

                        @Override
                        public String $vocabulary() {
                            return this.parameterSchema.$vocabulary();
                        }

                        @Override
                        public String $dynamicAnchor() {
                            return this.parameterSchema.$dynamicAnchor();
                        }

                        @Override
                        public String contentEncoding() {
                            return this.parameterSchema.contentEncoding();
                        }

                        @Override
                        public String contentMediaType() {
                            return this.parameterSchema.contentMediaType();
                        }

                        @Override
                        public Class<?> contentSchema() {
                            return this.parameterSchema.contentSchema();
                        }

                        @Override
                        public Class<?> propertyNames() {
                            return this.parameterSchema.propertyNames();
                        }

                        @Override
                        public int maxContains() {
                            return this.parameterSchema.maxContains();
                        }

                        @Override
                        public int minContains() {
                            return this.parameterSchema.minContains();
                        }

                        @Override
                        public Class<?> additionalItems() {
                            return this.parameterSchema.additionalItems();
                        }

                        @Override
                        public Class<?> unevaluatedItems() {
                            return this.parameterSchema.unevaluatedItems();
                        }

                        @Override
                        public Class<?> _if() {
                            return this.parameterSchema._if();
                        }

                        @Override
                        public Class<?> _else() {
                            return this.parameterSchema._else();
                        }

                        @Override
                        public Class<?> then() {
                            return this.parameterSchema.then();
                        }

                        @Override
                        public String $comment() {
                            return this.parameterSchema.$comment();
                        }

                        @Override
                        public Class<?>[] exampleClasses() {
                            return this.parameterSchema.exampleClasses();
                        }

                        @Override
                        public Schema.AdditionalPropertiesValue additionalProperties() {
                            return this.parameterSchema.additionalProperties();
                        }

                        @Override
                        public DependentRequired[] dependentRequiredMap() {
                            return this.parameterSchema.dependentRequiredMap();
                        }

                        @Override
                        public StringToClassMapItem[] dependentSchemas() {
                            return this.parameterSchema.dependentSchemas();
                        }

                        @Override
                        public StringToClassMapItem[] patternProperties() {
                            return this.parameterSchema.patternProperties();
                        }

                        @Override
                        public StringToClassMapItem[] properties() {
                            return this.parameterSchema.properties();
                        }

                        @Override
                        public Class<?> unevaluatedProperties() {
                            return this.parameterSchema.unevaluatedProperties();
                        }

                        @Override
                        public Class<?> additionalPropertiesSchema() {
                            return this.parameterSchema.additionalPropertiesSchema();
                        }

                        @Override
                        public String[] examples() {
                            return this.parameterSchema.examples();
                        }

                        @Override
                        public String _const() {
                            return this.parameterSchema._const();
                        }
                    };
                }

                @Override
                public ArraySchema array() {
                    final ArraySchema arraySchema = parameter.array();
                    return new ArraySchema(){

                        @Override
                        public Class<? extends Annotation> annotationType() {
                            return arraySchema.annotationType();
                        }

                        @Override
                        public Schema items() {
                            return arraySchema.items();
                        }

                        @Override
                        public Schema schema() {
                            return arraySchema.schema();
                        }

                        @Override
                        public Schema arraySchema() {
                            final Schema schema = arraySchema.arraySchema();
                            return new Schema(){

                                @Override
                                public Class<? extends Annotation> annotationType() {
                                    return schema.annotationType();
                                }

                                @Override
                                public Class<?> implementation() {
                                    return schema.implementation();
                                }

                                @Override
                                public Class<?> not() {
                                    return schema.not();
                                }

                                @Override
                                public Class<?>[] oneOf() {
                                    return schema.oneOf();
                                }

                                @Override
                                public Class<?>[] anyOf() {
                                    return schema.anyOf();
                                }

                                @Override
                                public Class<?>[] allOf() {
                                    return schema.allOf();
                                }

                                @Override
                                public String name() {
                                    return schema.name();
                                }

                                @Override
                                public String title() {
                                    return schema.title();
                                }

                                @Override
                                public double multipleOf() {
                                    return schema.multipleOf();
                                }

                                @Override
                                public String maximum() {
                                    return schema.maximum();
                                }

                                @Override
                                public boolean exclusiveMaximum() {
                                    return schema.exclusiveMaximum();
                                }

                                @Override
                                public String minimum() {
                                    return schema.minimum();
                                }

                                @Override
                                public boolean exclusiveMinimum() {
                                    return schema.exclusiveMinimum();
                                }

                                @Override
                                public int maxLength() {
                                    return schema.maxLength();
                                }

                                @Override
                                public int minLength() {
                                    return schema.minLength();
                                }

                                @Override
                                public String pattern() {
                                    return schema.pattern();
                                }

                                @Override
                                public int maxProperties() {
                                    return schema.maxProperties();
                                }

                                @Override
                                public int minProperties() {
                                    return schema.minProperties();
                                }

                                @Override
                                public String[] requiredProperties() {
                                    return schema.requiredProperties();
                                }

                                @Override
                                public boolean required() {
                                    return schema.required();
                                }

                                @Override
                                public Schema.RequiredMode requiredMode() {
                                    return schema.requiredMode();
                                }

                                @Override
                                public String description() {
                                    return schema.description();
                                }

                                @Override
                                public String format() {
                                    return schema.format();
                                }

                                @Override
                                public String ref() {
                                    return schema.ref();
                                }

                                @Override
                                public boolean nullable() {
                                    return schema.nullable();
                                }

                                @Override
                                public boolean readOnly() {
                                    return Schema.AccessMode.READ_ONLY.equals((Object)schema.accessMode());
                                }

                                @Override
                                public boolean writeOnly() {
                                    return Schema.AccessMode.WRITE_ONLY.equals((Object)schema.accessMode());
                                }

                                @Override
                                public Schema.AccessMode accessMode() {
                                    return schema.accessMode();
                                }

                                @Override
                                public String example() {
                                    return schema.example();
                                }

                                @Override
                                public ExternalDocumentation externalDocs() {
                                    return schema.externalDocs();
                                }

                                @Override
                                public boolean deprecated() {
                                    return schema.deprecated();
                                }

                                @Override
                                public String type() {
                                    return schema.type();
                                }

                                @Override
                                public String[] allowableValues() {
                                    return schema.allowableValues();
                                }

                                @Override
                                public String defaultValue() {
                                    return DataRestDelegatingMethodParameterCustomizer.this.getArrayDefaultValue(parameterName, pageableDefault, sortDefault, schema.defaultValue());
                                }

                                @Override
                                public String discriminatorProperty() {
                                    return schema.discriminatorProperty();
                                }

                                @Override
                                public DiscriminatorMapping[] discriminatorMapping() {
                                    return schema.discriminatorMapping();
                                }

                                @Override
                                public boolean hidden() {
                                    return schema.hidden();
                                }

                                @Override
                                public boolean enumAsRef() {
                                    return schema.enumAsRef();
                                }

                                @Override
                                public Class<?>[] subTypes() {
                                    return schema.subTypes();
                                }

                                @Override
                                public Extension[] extensions() {
                                    return schema.extensions();
                                }

                                @Override
                                public Class<?>[] prefixItems() {
                                    return schema.prefixItems();
                                }

                                @Override
                                public String[] types() {
                                    return schema.types();
                                }

                                @Override
                                public int exclusiveMaximumValue() {
                                    return schema.exclusiveMaximumValue();
                                }

                                @Override
                                public int exclusiveMinimumValue() {
                                    return schema.exclusiveMinimumValue();
                                }

                                @Override
                                public Class<?> contains() {
                                    return schema.contains();
                                }

                                @Override
                                public String $id() {
                                    return schema.$id();
                                }

                                @Override
                                public String $schema() {
                                    return schema.$schema();
                                }

                                @Override
                                public String $anchor() {
                                    return schema.$anchor();
                                }

                                @Override
                                public String $vocabulary() {
                                    return schema.$vocabulary();
                                }

                                @Override
                                public String $dynamicAnchor() {
                                    return schema.$dynamicAnchor();
                                }

                                @Override
                                public String contentEncoding() {
                                    return schema.contentEncoding();
                                }

                                @Override
                                public String contentMediaType() {
                                    return schema.contentMediaType();
                                }

                                @Override
                                public Class<?> contentSchema() {
                                    return schema.contentSchema();
                                }

                                @Override
                                public Class<?> propertyNames() {
                                    return schema.propertyNames();
                                }

                                @Override
                                public int maxContains() {
                                    return schema.maxContains();
                                }

                                @Override
                                public int minContains() {
                                    return schema.minContains();
                                }

                                @Override
                                public Class<?> additionalItems() {
                                    return schema.additionalItems();
                                }

                                @Override
                                public Class<?> unevaluatedItems() {
                                    return schema.unevaluatedItems();
                                }

                                @Override
                                public Class<?> _if() {
                                    return schema._if();
                                }

                                @Override
                                public Class<?> _else() {
                                    return schema._else();
                                }

                                @Override
                                public Class<?> then() {
                                    return schema.then();
                                }

                                @Override
                                public String $comment() {
                                    return schema.$comment();
                                }

                                @Override
                                public Class<?>[] exampleClasses() {
                                    return schema.exampleClasses();
                                }

                                @Override
                                public Schema.AdditionalPropertiesValue additionalProperties() {
                                    return schema.additionalProperties();
                                }

                                @Override
                                public DependentRequired[] dependentRequiredMap() {
                                    return schema.dependentRequiredMap();
                                }

                                @Override
                                public StringToClassMapItem[] dependentSchemas() {
                                    return schema.dependentSchemas();
                                }

                                @Override
                                public StringToClassMapItem[] patternProperties() {
                                    return schema.patternProperties();
                                }

                                @Override
                                public StringToClassMapItem[] properties() {
                                    return schema.properties();
                                }

                                @Override
                                public Class<?> unevaluatedProperties() {
                                    return schema.unevaluatedProperties();
                                }

                                @Override
                                public Class<?> additionalPropertiesSchema() {
                                    return schema.additionalPropertiesSchema();
                                }

                                @Override
                                public String[] examples() {
                                    return schema.examples();
                                }

                                @Override
                                public String _const() {
                                    return schema._const();
                                }

                                @Override
                                public Schema.SchemaResolution schemaResolution() {
                                    return schema.schemaResolution();
                                }
                            };
                        }

                        @Override
                        public int maxItems() {
                            return arraySchema.maxItems();
                        }

                        @Override
                        public int minItems() {
                            return arraySchema.minItems();
                        }

                        @Override
                        public boolean uniqueItems() {
                            return arraySchema.uniqueItems();
                        }

                        @Override
                        public Extension[] extensions() {
                            return arraySchema.extensions();
                        }

                        @Override
                        public Schema contains() {
                            return arraySchema.contains();
                        }

                        @Override
                        public int maxContains() {
                            return arraySchema.maxContains();
                        }

                        @Override
                        public int minContains() {
                            return arraySchema.minContains();
                        }

                        @Override
                        public Schema unevaluatedItems() {
                            return arraySchema.unevaluatedItems();
                        }

                        @Override
                        public Schema[] prefixItems() {
                            return arraySchema.prefixItems();
                        }
                    };
                }

                @Override
                public Content[] content() {
                    return parameter.content();
                }

                @Override
                public boolean hidden() {
                    return parameter.hidden();
                }

                @Override
                public ExampleObject[] examples() {
                    return parameter.examples();
                }

                @Override
                public String example() {
                    return parameter.example();
                }

                @Override
                public Extension[] extensions() {
                    return parameter.extensions();
                }

                @Override
                public String ref() {
                    return parameter.ref();
                }

                @Override
                public Class<?>[] validationGroups() {
                    return new Class[0];
                }
            };
            return Optional.of(parameterNew);
        }
        catch (NoSuchFieldException e) {
            LOGGER.warn(e.getMessage());
            return Optional.empty();
        }
    }

    private String getName(String parameterName, String originalName) {
        Object name = null;
        switch (parameterName) {
            case "size": {
                if (this.isRepositoryRestConfigurationPresent()) {
                    name = this.optionalRepositoryRestConfigurationProvider.get().getRepositoryRestConfiguration().getLimitParamName();
                    break;
                }
                if (this.isSpringDataWebPropertiesPresent()) {
                    name = this.optionalSpringDataWebPropertiesProvider.get().getSpringDataWebProperties().getPageable().getPrefix() + this.optionalSpringDataWebPropertiesProvider.get().getSpringDataWebProperties().getPageable().getSizeParameter();
                    break;
                }
                name = originalName;
                break;
            }
            case "sort": {
                if (this.isRepositoryRestConfigurationPresent()) {
                    name = this.optionalRepositoryRestConfigurationProvider.get().getRepositoryRestConfiguration().getSortParamName();
                    break;
                }
                if (this.isSpringDataWebPropertiesPresent()) {
                    name = this.optionalSpringDataWebPropertiesProvider.get().getSpringDataWebProperties().getSort().getSortParameter();
                    break;
                }
                name = originalName;
                break;
            }
            case "page": {
                if (this.isRepositoryRestConfigurationPresent()) {
                    name = this.optionalRepositoryRestConfigurationProvider.get().getRepositoryRestConfiguration().getPageParamName();
                    break;
                }
                if (this.isSpringDataWebPropertiesPresent()) {
                    name = this.optionalSpringDataWebPropertiesProvider.get().getSpringDataWebProperties().getPageable().getPrefix() + this.optionalSpringDataWebPropertiesProvider.get().getSpringDataWebProperties().getPageable().getPageParameter();
                    break;
                }
                name = originalName;
                break;
            }
            case "direction": 
            case "caseSensitive": {
                name = originalName;
                break;
            }
        }
        return name;
    }

    private String getDescription(String parameterName, String originalDescription) {
        if ("page".equals(parameterName) && this.isSpringDataWebPropertiesPresent() && this.optionalSpringDataWebPropertiesProvider.get().getSpringDataWebProperties().getPageable().isOneIndexedParameters()) {
            return "One-based page index (1..N)";
        }
        return originalDescription;
    }

    private String getDefaultValue(String parameterName, PageableDefault pageableDefault, String defaultSchemaVal) {
        String defaultValue = null;
        switch (parameterName) {
            case "size": {
                if (pageableDefault != null) {
                    Object defaultSize;
                    int size = pageableDefault.size();
                    try {
                        defaultSize = PageableDefault.class.getMethod("size", new Class[0]).getDefaultValue();
                    }
                    catch (NoSuchMethodException e) {
                        LOGGER.warn(e.getMessage());
                        defaultSize = null;
                    }
                    if (Objects.deepEquals(size, defaultSize)) {
                        size = pageableDefault.value();
                    }
                    defaultValue = String.valueOf(size);
                    break;
                }
                if (this.isRepositoryRestConfigurationPresent()) {
                    defaultValue = String.valueOf(this.optionalRepositoryRestConfigurationProvider.get().getRepositoryRestConfiguration().getDefaultPageSize());
                    break;
                }
                if (this.isSpringDataWebPropertiesPresent()) {
                    defaultValue = String.valueOf(this.optionalSpringDataWebPropertiesProvider.get().getSpringDataWebProperties().getPageable().getDefaultPageSize());
                    break;
                }
                defaultValue = defaultSchemaVal;
                break;
            }
            case "page": {
                if (pageableDefault != null) {
                    if (this.isSpringDataWebPropertiesPresent() && this.optionalSpringDataWebPropertiesProvider.get().getSpringDataWebProperties().getPageable().isOneIndexedParameters()) {
                        defaultValue = String.valueOf(pageableDefault.page() + 1);
                        break;
                    }
                    defaultValue = String.valueOf(pageableDefault.page());
                    break;
                }
                if (this.isSpringDataWebPropertiesPresent() && this.optionalSpringDataWebPropertiesProvider.get().getSpringDataWebProperties().getPageable().isOneIndexedParameters()) {
                    defaultValue = "1";
                    break;
                }
                defaultValue = defaultSchemaVal;
                break;
            }
        }
        return defaultValue;
    }

    private String getArrayDefaultValue(String parameterName, PageableDefault pageableDefault, SortDefault sortDefault, String defaultSchemaVal) {
        DefaultSort defaultSort;
        String defaultValue = defaultSchemaVal;
        if ("sort".equals(parameterName) && (defaultSort = this.getDefaultSort(pageableDefault, sortDefault)) != null && ArrayUtils.isNotEmpty(defaultSort.properties)) {
            List<String> sortValues = defaultSort.getEffectiveProperties();
            try {
                defaultValue = ObjectMapperFactory.buildStrictGenericObjectMapper().writeValueAsString(sortValues);
            }
            catch (JsonProcessingException e) {
                LOGGER.warn(e.getMessage());
            }
        }
        return defaultValue;
    }

    private DefaultSort getDefaultSort(PageableDefault pageableDefault, SortDefault sortDefault) {
        if (sortDefault != null) {
            Object defaultSort;
            String[] sortProperties = sortDefault.sort();
            try {
                defaultSort = SortDefault.class.getMethod("sort", new Class[0]).getDefaultValue();
            }
            catch (NoSuchMethodException e) {
                LOGGER.warn(e.getMessage());
                defaultSort = null;
            }
            if (!Objects.deepEquals(sortProperties, defaultSort)) {
                return new DefaultSort(sortDefault.direction(), sortProperties);
            }
            sortProperties = sortDefault.value();
            try {
                defaultSort = SortDefault.class.getMethod("value", new Class[0]).getDefaultValue();
            }
            catch (NoSuchMethodException e) {
                LOGGER.warn(e.getMessage());
                defaultSort = null;
            }
            if (!Objects.deepEquals(sortProperties, defaultSort)) {
                return new DefaultSort(sortDefault.direction(), sortProperties);
            }
        }
        if (pageableDefault != null) {
            return new DefaultSort(pageableDefault.direction(), pageableDefault.sort());
        }
        return null;
    }

    private boolean isSpringDataWebPropertiesPresent() {
        return this.optionalSpringDataWebPropertiesProvider.isPresent() && this.optionalSpringDataWebPropertiesProvider.get().isSpringDataWebPropertiesPresent();
    }

    private boolean isRepositoryRestConfigurationPresent() {
        return this.optionalRepositoryRestConfigurationProvider.isPresent() && this.optionalRepositoryRestConfigurationProvider.get().isRepositoryRestConfigurationPresent();
    }

    private static class DefaultSort {
        private static final String DIRECTION_GROUP = Arrays.stream(Sort.Direction.values()).map(Enum::name).collect(Collectors.joining("|"));
        private static final String DIRECTED_REGEXP = "\\w+(\\.\\w+)*,\\s*(" + DIRECTION_GROUP + ")";
        private static final Pattern DIRECTED_PATTERN = Pattern.compile(DIRECTED_REGEXP, 2);
        private final Sort.Direction direction;
        private final String[] properties;

        DefaultSort(Sort.Direction direction, String ... properties) {
            this.direction = direction;
            this.properties = properties;
        }

        List<String> getEffectiveProperties() {
            return Arrays.stream(this.properties).map(p -> {
                if (DIRECTED_PATTERN.matcher((CharSequence)p).matches()) {
                    return p;
                }
                return p + "," + this.direction.name();
            }).toList();
        }
    }
}

