/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.converters;

import com.hazelcast.shaded.com.fasterxml.jackson.databind.JavaType;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.util.Iterator;
import org.springdoc.core.converters.ConverterUtils;
import org.springdoc.core.providers.ObjectMapperProvider;
import org.springframework.http.ResponseEntity;

public class ResponseSupportConverter
implements ModelConverter {
    private final ObjectMapperProvider springDocObjectMapper;

    public ResponseSupportConverter(ObjectMapperProvider springDocObjectMapper) {
        this.springDocObjectMapper = springDocObjectMapper;
    }

    @Override
    public Schema resolve(AnnotatedType type, ModelConverterContext context, Iterator<ModelConverter> chain) {
        JavaType javaType = this.springDocObjectMapper.jsonMapper().constructType(type.getType());
        if (javaType != null) {
            Class<?> cls = javaType.getRawClass();
            if (ConverterUtils.isResponseTypeWrapper(cls) && !ConverterUtils.isFluxTypeWrapper(cls)) {
                JavaType innerType = this.findResponseEntity(javaType).containedType(0);
                if (innerType == null) {
                    return new StringSchema();
                }
                if (Object.class.equals(innerType.getRawClass())) {
                    return new ObjectSchema();
                }
                return context.resolve(new AnnotatedType(innerType).jsonViewAnnotation(type.getJsonViewAnnotation()).ctxAnnotations(type.getCtxAnnotations()).resolveAsRef(true));
            }
            if (ConverterUtils.isResponseTypeToIgnore(cls)) {
                return null;
            }
        }
        return chain.hasNext() ? chain.next().resolve(type, context, chain) : null;
    }

    private JavaType findResponseEntity(JavaType javaType) {
        if (ResponseEntity.class.isAssignableFrom(javaType.getRawClass())) {
            while (ResponseEntity.class != javaType.getRawClass()) {
                javaType = javaType.getSuperClass();
            }
        }
        return javaType;
    }
}

