/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.conditions;

import java.util.Set;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class SpecPropertiesCondition
implements Condition {
    @Override
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        BindResult<SpringDocConfigProperties> result = Binder.get(context.getEnvironment()).bind("springdoc", SpringDocConfigProperties.class);
        if (result.isBound()) {
            SpringDocConfigProperties springDocConfigProperties = result.get();
            if (springDocConfigProperties.getOpenApi() != null) {
                return true;
            }
            Set<SpringDocConfigProperties.GroupConfig> groupConfigs = springDocConfigProperties.getGroupConfigs();
            return groupConfigs.stream().anyMatch(config -> config.getOpenApi() != null);
        }
        return false;
    }
}

