/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.catalina.connector.OutputBuffer;
import org.apache.tomcat.util.res.StringManager;

public class CoyoteOutputStream
extends ServletOutputStream {
    protected static final StringManager sm = StringManager.getManager(CoyoteOutputStream.class);
    protected OutputBuffer ob;

    protected CoyoteOutputStream(OutputBuffer ob) {
        this.ob = ob;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    void clear() {
        this.ob = null;
    }

    @Override
    public void write(int i2) throws IOException {
        boolean nonBlocking = this.checkNonBlockingWrite();
        try {
            this.ob.writeByte(i2);
        }
        catch (IOException ioe) {
            this.handleIOException(ioe);
        }
        if (nonBlocking) {
            this.checkRegisterForWrite();
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        boolean nonBlocking = this.checkNonBlockingWrite();
        try {
            this.ob.write(b, off, len);
        }
        catch (IOException ioe) {
            this.handleIOException(ioe);
        }
        if (nonBlocking) {
            this.checkRegisterForWrite();
        }
    }

    public void write(ByteBuffer from) throws IOException {
        Objects.requireNonNull(from);
        boolean nonBlocking = this.checkNonBlockingWrite();
        try {
            this.ob.write(from);
        }
        catch (IOException ioe) {
            this.handleIOException(ioe);
        }
        if (nonBlocking) {
            this.checkRegisterForWrite();
        }
    }

    @Override
    public void flush() throws IOException {
        boolean nonBlocking = this.checkNonBlockingWrite();
        try {
            this.ob.flush();
        }
        catch (IOException ioe) {
            this.handleIOException(ioe);
        }
        if (nonBlocking) {
            this.checkRegisterForWrite();
        }
    }

    private boolean checkNonBlockingWrite() {
        boolean nonBlocking;
        boolean bl = nonBlocking = !this.ob.isBlocking();
        if (nonBlocking && !this.ob.isReady()) {
            throw new IllegalStateException(sm.getString("coyoteOutputStream.nbNotready"));
        }
        return nonBlocking;
    }

    private void checkRegisterForWrite() {
        this.ob.checkRegisterForWrite();
    }

    @Override
    public void close() throws IOException {
        try {
            this.ob.close();
        }
        catch (IOException ioe) {
            this.handleIOException(ioe);
        }
    }

    @Override
    public boolean isReady() {
        if (this.ob == null) {
            throw new IllegalStateException(sm.getString("coyoteOutputStream.null"));
        }
        return this.ob.isReady();
    }

    @Override
    public void setWriteListener(WriteListener listener) {
        this.ob.setWriteListener(listener);
    }

    private void handleIOException(IOException ioe) throws IOException {
        try {
            this.ob.setErrorException(ioe);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        throw ioe;
    }
}

