/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.jakarta9.instrument.jms;

import io.micrometer.common.KeyValue;
import io.micrometer.common.lang.Nullable;
import io.micrometer.jakarta9.instrument.jms.JmsObservationDocumentation;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.Topic;

class JmsKeyValues {
    private static final KeyValue DESTINATION_TEMPORARY = KeyValue.of(JmsObservationDocumentation.LowCardinalityKeyNames.DESTINATION_TEMPORARY, "true");
    private static final KeyValue DESTINATION_DURABLE = KeyValue.of(JmsObservationDocumentation.LowCardinalityKeyNames.DESTINATION_TEMPORARY, "false");
    private static final KeyValue MESSAGE_CONVERSATION_ID_UNKNOWN = KeyValue.of(JmsObservationDocumentation.HighCardinalityKeyNames.CONVERSATION_ID, "unknown");
    private static final KeyValue DESTINATION_NAME_UNKNOWN = KeyValue.of(JmsObservationDocumentation.HighCardinalityKeyNames.DESTINATION_NAME, "unknown");
    private static final KeyValue MESSAGE_ID_UNKNOWN = KeyValue.of(JmsObservationDocumentation.HighCardinalityKeyNames.MESSAGE_ID, "unknown");

    private JmsKeyValues() {
    }

    static KeyValue conversationId(@Nullable Message message) {
        try {
            if (message == null || message.getJMSCorrelationID() == null) {
                return MESSAGE_CONVERSATION_ID_UNKNOWN;
            }
            return KeyValue.of(JmsObservationDocumentation.HighCardinalityKeyNames.CONVERSATION_ID, message.getJMSCorrelationID());
        }
        catch (JMSException exc) {
            return MESSAGE_CONVERSATION_ID_UNKNOWN;
        }
    }

    static KeyValue destinationName(@Nullable Message message) {
        if (message == null) {
            return DESTINATION_NAME_UNKNOWN;
        }
        try {
            Queue queue;
            String queueName;
            Destination destination = message.getJMSDestination();
            if (destination instanceof Queue && (queueName = (queue = (Queue)destination).getQueueName()) != null) {
                return KeyValue.of(JmsObservationDocumentation.HighCardinalityKeyNames.DESTINATION_NAME, queueName);
            }
            return JmsKeyValues.getKeyValueTopic(destination);
        }
        catch (JMSException e) {
            return DESTINATION_NAME_UNKNOWN;
        }
    }

    static KeyValue messageId(@Nullable Message message) {
        try {
            if (message == null || message.getJMSMessageID() == null) {
                return MESSAGE_ID_UNKNOWN;
            }
            return KeyValue.of(JmsObservationDocumentation.HighCardinalityKeyNames.MESSAGE_ID, message.getJMSMessageID());
        }
        catch (JMSException exc) {
            return MESSAGE_ID_UNKNOWN;
        }
    }

    static KeyValue temporaryDestination(@Nullable Message message) {
        try {
            Destination destination;
            if (message != null && ((destination = message.getJMSDestination()) instanceof TemporaryQueue || destination instanceof TemporaryTopic)) {
                return DESTINATION_TEMPORARY;
            }
            return DESTINATION_DURABLE;
        }
        catch (JMSException exc) {
            return DESTINATION_DURABLE;
        }
    }

    private static KeyValue getKeyValueTopic(Destination jmsDestination) throws JMSException {
        Topic topic;
        String topicName;
        if (jmsDestination instanceof Topic && (topicName = (topic = (Topic)jmsDestination).getTopicName()) != null) {
            return KeyValue.of(JmsObservationDocumentation.HighCardinalityKeyNames.DESTINATION_NAME, topicName);
        }
        return DESTINATION_NAME_UNKNOWN;
    }
}

