/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.lang;

import io.jsonwebtoken.lang.Collections;
import io.jsonwebtoken.lang.Objects;
import io.jsonwebtoken.lang.Strings;
import java.util.Collection;
import java.util.Map;

public final class Assert {
    private Assert() {
    }

    public static void isTrue(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isTrue(boolean expression) {
        Assert.isTrue(expression, "[Assertion failed] - this expression must be true");
    }

    public static void isNull(Object object, String message) {
        if (object != null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isNull(Object object) {
        Assert.isNull(object, "[Assertion failed] - the object argument must be null");
    }

    public static <T> T notNull(T object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
        return object;
    }

    public static void notNull(Object object) {
        Assert.notNull(object, "[Assertion failed] - this argument is required; it must not be null");
    }

    public static void hasLength(String text, String message) {
        if (!Strings.hasLength(text)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void hasLength(String text) {
        Assert.hasLength(text, "[Assertion failed] - this String argument must have length; it must not be null or empty");
    }

    public static <T extends CharSequence> T hasText(T text, String message) {
        if (!Strings.hasText(text)) {
            throw new IllegalArgumentException(message);
        }
        return text;
    }

    public static void hasText(String text) {
        Assert.hasText(text, "[Assertion failed] - this String argument must have text; it must not be null, empty, or blank");
    }

    public static void doesNotContain(String textToSearch, String substring, String message) {
        if (Strings.hasLength(textToSearch) && Strings.hasLength(substring) && textToSearch.indexOf(substring) != -1) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void doesNotContain(String textToSearch, String substring) {
        Assert.doesNotContain(textToSearch, substring, "[Assertion failed] - this String argument must not contain the substring [" + substring + "]");
    }

    public static Object[] notEmpty(Object[] array, String message) {
        if (Objects.isEmpty(array)) {
            throw new IllegalArgumentException(message);
        }
        return array;
    }

    public static void notEmpty(Object[] array) {
        Assert.notEmpty(array, "[Assertion failed] - this array must not be empty: it must contain at least 1 element");
    }

    public static byte[] notEmpty(byte[] array, String msg) {
        if (Objects.isEmpty(array)) {
            throw new IllegalArgumentException(msg);
        }
        return array;
    }

    public static char[] notEmpty(char[] chars, String msg) {
        if (Objects.isEmpty(chars)) {
            throw new IllegalArgumentException(msg);
        }
        return chars;
    }

    public static void noNullElements(Object[] array, String message) {
        if (array != null) {
            for (int i2 = 0; i2 < array.length; ++i2) {
                if (array[i2] != null) continue;
                throw new IllegalArgumentException(message);
            }
        }
    }

    public static void noNullElements(Object[] array) {
        Assert.noNullElements(array, "[Assertion failed] - this array must not contain any null elements");
    }

    public static <T extends Collection<?>> T notEmpty(T collection, String message) {
        if (Collections.isEmpty(collection)) {
            throw new IllegalArgumentException(message);
        }
        return collection;
    }

    public static void notEmpty(Collection<?> collection) {
        Assert.notEmpty(collection, "[Assertion failed] - this collection must not be empty: it must contain at least 1 element");
    }

    public static <T extends Map<?, ?>> T notEmpty(T map, String message) {
        if (Collections.isEmpty(map)) {
            throw new IllegalArgumentException(message);
        }
        return map;
    }

    public static void notEmpty(Map map) {
        Assert.notEmpty(map, "[Assertion failed] - this map must not be empty; it must contain at least one entry");
    }

    public static <T> T isInstanceOf(Class<T> clazz, Object obj) {
        return Assert.isInstanceOf(clazz, obj, "");
    }

    public static <T> T isInstanceOf(Class<T> type, Object obj, String message) {
        Assert.notNull(type, "Type to check against must not be null");
        if (!type.isInstance(obj)) {
            throw new IllegalArgumentException(message + "Object of class [" + (obj != null ? obj.getClass().getName() : "null") + "] must be an instance of " + type);
        }
        return type.cast(obj);
    }

    public static <T> T stateIsInstance(Class<T> type, Object obj, String message) {
        Assert.notNull(type, "Type to check cannot be null.");
        if (!type.isInstance(obj)) {
            String msg = message + "Object of class [" + Objects.nullSafeClassName(obj) + "] must be an instance of " + type;
            throw new IllegalStateException(msg);
        }
        return type.cast(obj);
    }

    public static void isAssignable(Class superType, Class subType) {
        Assert.isAssignable(superType, subType, "");
    }

    public static void isAssignable(Class superType, Class subType, String message) {
        Assert.notNull(superType, "Type to check against must not be null");
        if (subType == null || !superType.isAssignableFrom(subType)) {
            throw new IllegalArgumentException(message + subType + " is not assignable to " + superType);
        }
    }

    public static <T extends Comparable<T>> T eq(T value, T requirement, String msg) {
        if (Assert.compareTo(value, requirement) != 0) {
            throw new IllegalArgumentException(msg);
        }
        return value;
    }

    private static <T extends Comparable<T>> int compareTo(T value, T requirement) {
        Assert.notNull(value, "value cannot be null.");
        Assert.notNull(requirement, "requirement cannot be null.");
        return value.compareTo(requirement);
    }

    public static <T extends Comparable<T>> T gt(T value, T requirement, String msg) {
        if (Assert.compareTo(value, requirement) <= 0) {
            throw new IllegalArgumentException(msg);
        }
        return value;
    }

    public static <T extends Comparable<T>> T lte(T value, T requirement, String msg) {
        if (Assert.compareTo(value, requirement) > 0) {
            throw new IllegalArgumentException(msg);
        }
        return value;
    }

    public static void state(boolean expression, String message) {
        if (!expression) {
            throw new IllegalStateException(message);
        }
    }

    public static void state(boolean expression) {
        Assert.state(expression, "[Assertion failed] - this state invariant must be true");
    }

    public static <T> T stateNotNull(T value, String msg) throws IllegalStateException {
        if (value == null) {
            throw new IllegalStateException(msg);
        }
        return value;
    }
}

