/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.jackson.io;

import com.hazelcast.shaded.com.fasterxml.jackson.core.JsonParser;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.JavaType;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.deser.std.UntypedObjectDeserializer;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.module.SimpleModule;
import io.jsonwebtoken.io.AbstractDeserializer;
import io.jsonwebtoken.jackson.io.JacksonSerializer;
import io.jsonwebtoken.lang.Assert;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.Map;

public class JacksonDeserializer<T>
extends AbstractDeserializer<T> {
    private final Class<T> returnType;
    private final ObjectMapper objectMapper;

    public JacksonDeserializer() {
        this(JacksonSerializer.DEFAULT_OBJECT_MAPPER);
    }

    public JacksonDeserializer(Map<String, Class<?>> claimTypeMap) {
        this(JacksonSerializer.newObjectMapper(), claimTypeMap);
    }

    public JacksonDeserializer(ObjectMapper objectMapper) {
        this(objectMapper, Object.class);
    }

    private JacksonDeserializer(ObjectMapper objectMapper, Map<String, Class<?>> claimTypeMap) {
        this(objectMapper);
        Assert.notNull(claimTypeMap, "Claim type map cannot be null.");
        SimpleModule module = new SimpleModule();
        module.addDeserializer(Object.class, new MappedTypeDeserializer(Collections.unmodifiableMap(claimTypeMap)));
        objectMapper.registerModule(module);
    }

    private JacksonDeserializer(ObjectMapper objectMapper, Class<T> returnType) {
        Assert.notNull(objectMapper, "ObjectMapper cannot be null.");
        Assert.notNull(returnType, "Return type cannot be null.");
        this.objectMapper = objectMapper;
        this.returnType = returnType;
    }

    @Override
    protected T doDeserialize(Reader reader) throws Exception {
        return this.objectMapper.readValue(reader, this.returnType);
    }

    private static class MappedTypeDeserializer
    extends UntypedObjectDeserializer {
        private final Map<String, Class<?>> claimTypeMap;

        private MappedTypeDeserializer(Map<String, Class<?>> claimTypeMap) {
            super((JavaType)null, (JavaType)null);
            this.claimTypeMap = claimTypeMap;
        }

        @Override
        public Object deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            String name = parser.currentName();
            if (this.claimTypeMap != null && name != null && this.claimTypeMap.containsKey(name)) {
                Class<?> type = this.claimTypeMap.get(name);
                return parser.readValueAsTree().traverse(parser.getCodec()).readValueAs(type);
            }
            return super.deserialize(parser, context);
        }
    }
}

