/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.lang;

import io.jsonwebtoken.impl.lang.UnavailableImplementationException;
import io.jsonwebtoken.lang.Arrays;
import io.jsonwebtoken.lang.Assert;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class Services {
    private static final ConcurrentMap<Class<?>, Object> SERVICES = new ConcurrentHashMap();
    private static final List<ClassLoaderAccessor> CLASS_LOADER_ACCESSORS = Arrays.asList(new ClassLoaderAccessor[]{new ClassLoaderAccessor(){

        @Override
        public ClassLoader getClassLoader() {
            return Thread.currentThread().getContextClassLoader();
        }
    }, new ClassLoaderAccessor(){

        @Override
        public ClassLoader getClassLoader() {
            return Services.class.getClassLoader();
        }
    }, new ClassLoaderAccessor(){

        @Override
        public ClassLoader getClassLoader() {
            return ClassLoader.getSystemClassLoader();
        }
    }});

    private Services() {
    }

    public static <T> T get(Class<T> spi) {
        T instance = Services.findCached(spi);
        if (instance == null) {
            instance = Services.loadFirst(spi);
            SERVICES.putIfAbsent(spi, instance);
        }
        return instance;
    }

    private static <T> T findCached(Class<T> spi) {
        Assert.notNull(spi, "Service interface cannot be null.");
        Object obj = SERVICES.get(spi);
        if (obj != null) {
            return Assert.isInstanceOf(spi, obj, "Unexpected cached service implementation type.");
        }
        return null;
    }

    private static <T> T loadFirst(Class<T> spi) {
        for (ClassLoaderAccessor accessor : CLASS_LOADER_ACCESSORS) {
            ServiceLoader<T> loader = ServiceLoader.load(spi, accessor.getClassLoader());
            Assert.stateNotNull(loader, "JDK ServiceLoader#load should never return null.");
            Iterator<T> i2 = loader.iterator();
            Assert.stateNotNull(i2, "JDK ServiceLoader#iterator() should never return null.");
            if (!i2.hasNext()) continue;
            return i2.next();
        }
        throw new UnavailableImplementationException(spi);
    }

    public static void reload() {
        SERVICES.clear();
    }

    private static interface ClassLoaderAccessor {
        public ClassLoader getClassLoader();
    }
}

