/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl;

import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.impl.DefaultTokenizedJwe;
import io.jsonwebtoken.impl.DefaultTokenizedJwt;
import io.jsonwebtoken.impl.TokenizedJwt;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Strings;
import java.io.IOException;
import java.io.Reader;

public class JwtTokenizer {
    static final char DELIMITER = '.';
    private static final String DELIM_ERR_MSG_PREFIX = "Invalid compact JWT string: Compact JWSs must contain exactly 2 period characters, and compact JWEs must contain exactly 4.  Found: ";

    private static int read(Reader r, char[] buf) {
        try {
            return r.read(buf);
        }
        catch (IOException e) {
            String msg = "Unable to read compact JWT: " + e.getMessage();
            throw new MalformedJwtException(msg, e);
        }
    }

    public <T extends TokenizedJwt> T tokenize(Reader reader) {
        Assert.notNull(reader, "Reader argument cannot be null.");
        String protectedHeader = "";
        String body2 = "";
        String encryptedKey = "";
        String iv = "";
        String digest = "";
        int delimiterCount = 0;
        char[] buf = new char[4096];
        int len = 0;
        StringBuilder sb = new StringBuilder(4096);
        while (len != -1) {
            len = JwtTokenizer.read(reader, buf);
            for (int i2 = 0; i2 < len; ++i2) {
                char c = buf[i2];
                if (Character.isWhitespace(c)) {
                    String msg = "Compact JWT strings may not contain whitespace.";
                    throw new MalformedJwtException(msg);
                }
                if (c == '.') {
                    CharSequence seq = Strings.clean(sb);
                    String token = seq != null ? seq.toString() : "";
                    switch (delimiterCount) {
                        case 0: {
                            protectedHeader = token;
                            break;
                        }
                        case 1: {
                            body2 = token;
                            encryptedKey = token;
                            break;
                        }
                        case 2: {
                            body2 = "";
                            iv = token;
                            break;
                        }
                        case 3: {
                            body2 = token;
                        }
                    }
                    ++delimiterCount;
                    sb.setLength(0);
                    continue;
                }
                sb.append(c);
            }
        }
        if (delimiterCount != 2 && delimiterCount != 4) {
            String msg = DELIM_ERR_MSG_PREFIX + delimiterCount;
            throw new MalformedJwtException(msg);
        }
        if (sb.length() > 0) {
            digest = sb.toString();
        }
        if (delimiterCount == 2) {
            return (T)new DefaultTokenizedJwt(protectedHeader, body2, digest);
        }
        return (T)new DefaultTokenizedJwe(protectedHeader, body2, digest, encryptedKey, iv);
    }
}

