/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.com.fasterxml.jackson.datatype.jdk8;

import com.hazelcast.shaded.com.fasterxml.jackson.databind.BeanDescription;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.JavaType;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.SerializationConfig;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.hazelcast.shaded.com.fasterxml.jackson.datatype.jdk8.Jdk8OptionalBeanPropertyWriter;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

public class Jdk8BeanSerializerModifier
extends BeanSerializerModifier {
    private static final long serialVersionUID = 1L;

    @Override
    public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
        for (int i2 = 0; i2 < beanProperties.size(); ++i2) {
            Object empty;
            BeanPropertyWriter writer = beanProperties.get(i2);
            JavaType type = writer.getType();
            if (type.isTypeOrSubTypeOf(Optional.class)) {
                empty = Optional.empty();
            } else if (type.hasRawClass(OptionalLong.class)) {
                empty = OptionalLong.empty();
            } else if (type.hasRawClass(OptionalInt.class)) {
                empty = OptionalInt.empty();
            } else {
                if (!type.hasRawClass(OptionalDouble.class)) continue;
                empty = OptionalDouble.empty();
            }
            beanProperties.set(i2, new Jdk8OptionalBeanPropertyWriter(writer, empty));
        }
        return beanProperties;
    }
}

